/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.message.entity;

import java.util.Arrays;

public class Message {
    private static final int QOS0 = 0;
    private static final int QOS1 = 1;
    private static final int QOS2 = 2;
    private byte[] payload;
    private String messageId;
    private String topic;
    private int qos;
    private long generateTime;

    public void setQos(int qos) {
        if (qos < 0 || qos > 2) {
            throw new IllegalArgumentException();
        }
        this.qos = qos;
    }

    public Message(byte[] payload) {
        this.payload = payload;
    }

    public Message(byte[] payload, int qos) {
        this.payload = payload;
        this.qos = qos;
    }

    public Message(byte[] payload, String topic, String messageId, int qos, long generateTime) {
        this.payload = payload;
        this.topic = topic;
        this.messageId = messageId;
        this.qos = qos;
        this.generateTime = generateTime;
    }

    public Message() {
    }

    public String toString() {
        return "Message{payload=" + new String(this.payload) + ", topic='" + this.topic + '\'' + ", messageId='" + this.messageId + '\'' + ", qos=" + this.qos + ", generateTime=" + this.generateTime + '}';
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQos() {
        return this.qos;
    }

    public long getGenerateTime() {
        return this.generateTime;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getPayload(), other.getPayload())) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        if (this.getQos() != other.getQos()) {
            return false;
        }
        return this.getGenerateTime() == other.getGenerateTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getPayload());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        result = result * 59 + this.getQos();
        long $generateTime = this.getGenerateTime();
        result = result * 59 + (int)($generateTime >>> 32 ^ $generateTime);
        return result;
    }
}

