/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.dispatch.AsyncDispatcher;
import com.aliyun.openservices.ons.api.Admin;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentials;
import com.aliyun.openservices.ons.api.impl.rocketmq.FAQ;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.ons.api.impl.util.NameAddrUtils;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.namesrv.TopAddressing;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ONSClientAbstract
implements Admin {
    protected static final String WSADDR_INTERNAL = System.getProperty("com.aliyun.openservices.ons.addr.internal", "http://onsaddr-internal.aliyun.com:8080/rocketmq/nsaddr4client-internal");
    protected static final String WSADDR_INTERNET = System.getProperty("com.aliyun.openservices.ons.addr.internet", "http://onsaddr-internet.aliyun.com/rocketmq/nsaddr4client-internet");
    protected static final long WSADDR_INTERNAL_TIMEOUTMILLS = Long.parseLong(System.getProperty("com.aliyun.openservices.ons.addr.internal.timeoutmills", "3000"));
    protected static final long WSADDR_INTERNET_TIMEOUTMILLS = Long.parseLong(System.getProperty("com.aliyun.openservices.ons.addr.internet.timeoutmills", "5000"));
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    protected final Properties properties;
    protected final SessionCredentials sessionCredentials = new SessionCredentials();
    protected String nameServerAddr = NameAddrUtils.getNameAdd();
    protected AsyncDispatcher traceDispatcher = null;
    protected final AtomicBoolean started = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ONSClient-UpdateNameServerThread");
        }
    });

    public ONSClientAbstract(Properties properties) {
        this.properties = properties;
        this.sessionCredentials.updateContent(properties);
        if (null == this.sessionCredentials.getAccessKey() || "".equals(this.sessionCredentials.getAccessKey())) {
            throw new ONSClientException("please set access key");
        }
        if (null == this.sessionCredentials.getSecretKey() || "".equals(this.sessionCredentials.getSecretKey())) {
            throw new ONSClientException("please set secret key");
        }
        if (null == this.sessionCredentials.getOnsChannel()) {
            throw new ONSClientException("please set ons channel");
        }
        this.nameServerAddr = this.getNameSrvAddrFromProperties();
        if (this.nameServerAddr != null) {
            return;
        }
        this.nameServerAddr = this.fetchNameServerAddr();
        if (null == this.nameServerAddr) {
            throw new ONSClientException(FAQ.errorMessage("Can not find name server, May be your network problem.", "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&namesrv_not_exist"));
        }
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    String nsAddrs = ONSClientAbstract.this.fetchNameServerAddr();
                    if (nsAddrs != null && !ONSClientAbstract.this.nameServerAddr.equals(nsAddrs)) {
                        ONSClientAbstract.this.nameServerAddr = nsAddrs;
                        if (ONSClientAbstract.this.isStarted()) {
                            ONSClientAbstract.this.updateNameServerAddr(nsAddrs);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("update name server periodically failed.", e);
                }
            }
        }, 10000L, 90000L, TimeUnit.MILLISECONDS);
    }

    protected abstract void updateNameServerAddr(String var1);

    private String getNameSrvAddrFromProperties() {
        String nameserverAddrs = this.properties.getProperty("NAMESRV_ADDR");
        if (StringUtils.isNotEmpty(nameserverAddrs) && NameAddrUtils.NAMESRV_ENDPOINT_PATTERN.matcher(nameserverAddrs.trim()).matches()) {
            return nameserverAddrs.substring("http://".length());
        }
        return nameserverAddrs;
    }

    private String fetchNameServerAddr() {
        String property = this.properties.getProperty("ONSAddr");
        if (property != null) {
            String nsAddrs = new TopAddressing(property).fetchNSAddr();
            if (nsAddrs != null) {
                LOGGER.info("connected to user-defined ons addr server, {} success, {}", (Object)property, (Object)nsAddrs);
                return nsAddrs;
            }
            throw new ONSClientException(FAQ.errorMessage("Can not find name server with onsAddr " + property, "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&namesrv_not_exist"));
        }
        TopAddressing top = new TopAddressing(WSADDR_INTERNAL);
        String nsAddrs = top.fetchNSAddr(false, WSADDR_INTERNAL_TIMEOUTMILLS);
        if (nsAddrs != null) {
            LOGGER.info("connected to internal server, {} success, {}", (Object)WSADDR_INTERNAL, (Object)nsAddrs);
            return nsAddrs;
        }
        top = new TopAddressing(WSADDR_INTERNET);
        nsAddrs = top.fetchNSAddr(false, WSADDR_INTERNET_TIMEOUTMILLS);
        if (nsAddrs != null) {
            LOGGER.info("connected to internet server, {} success, {}", (Object)WSADDR_INTERNET, (Object)nsAddrs);
        }
        return nsAddrs;
    }

    public String getNameServerAddr() {
        return this.nameServerAddr;
    }

    protected String buildIntanceName() {
        return Integer.toString(UtilAll.getPid()) + "#" + this.nameServerAddr.hashCode() + "#" + this.sessionCredentials.getAccessKey().hashCode() + "#" + System.nanoTime();
    }

    protected String getNamespace() {
        String namespaceFromProperty;
        String namespace = null;
        String nameserverAddr = this.properties.getProperty("NAMESRV_ADDR");
        if (StringUtils.isNotEmpty(nameserverAddr) && NameAddrUtils.validateInstanceEndpoint(nameserverAddr)) {
            namespace = NameAddrUtils.parseInstanceIdFromEndpoint(nameserverAddr);
            LOGGER.info("User specify namespace by endpoint: {}.", (Object)namespace);
        }
        if (StringUtils.isNotEmpty(namespaceFromProperty = this.properties.getProperty("INSTANCE_ID", null))) {
            namespace = namespaceFromProperty;
            LOGGER.info("User specify namespace by property: {}.", (Object)namespace);
        }
        return namespace;
    }

    protected void checkONSProducerServiceState(DefaultMQProducerImpl producer) {
        switch (producer.getServiceState()) {
            case CREATE_JUST: {
                throw new ONSClientException(FAQ.errorMessage(String.format("You do not have start the producer[" + UtilAll.getPid() + "], %s", new Object[]{producer.getServiceState()}), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&service_not_ok"));
            }
            case SHUTDOWN_ALREADY: {
                throw new ONSClientException(FAQ.errorMessage(String.format("Your producer has been shut down, %s", new Object[]{producer.getServiceState()}), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&service_not_ok"));
            }
            case START_FAILED: {
                throw new ONSClientException(FAQ.errorMessage(String.format("When you start your service throws an exception, %s", new Object[]{producer.getServiceState()}), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&service_not_ok"));
            }
            case RUNNING: {
                break;
            }
        }
    }

    @Override
    public void start() {
        if (null != this.traceDispatcher) {
            try {
                this.traceDispatcher.start();
            }
            catch (MQClientException e) {
                LOGGER.warn("trace dispatcher start failed ", e);
            }
        }
    }

    @Override
    public void updateCredential(Properties credentialProperties) {
        if (null == credentialProperties.getProperty("AccessKey") || "".equals(credentialProperties.getProperty("AccessKey"))) {
            throw new ONSClientException("update credential failed. please set access key.");
        }
        if (null == credentialProperties.getProperty("SecretKey") || "".equals(credentialProperties.getProperty("SecretKey"))) {
            throw new ONSClientException("update credential failed. please set secret key");
        }
        this.sessionCredentials.updateContent(credentialProperties);
    }

    @Override
    public void shutdown() {
        if (null != this.traceDispatcher) {
            this.traceDispatcher.shutdown();
        }
        this.scheduledExecutorService.shutdown();
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public boolean isClosed() {
        return !this.isStarted();
    }
}

