/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.vtoa;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.vtoa.Vtoa;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.socket.DefaultSocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioSocketChannel;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.net.Socket;
import java.nio.channels.SocketChannel;

public class VpcTunnelUtils {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    public static final String PROPERTY_VTOA_TUNNEL_ID = "VTOA_TUNNEL_ID";
    private static VpcTunnelUtils instance;

    public static native int getvip(int var0, Vtoa var1);

    public static VpcTunnelUtils getInstance() {
        return instance;
    }

    public Vtoa getTunnelID(ChannelHandlerContext ctx) {
        Vtoa vtoa = new Vtoa(-1, -1, -1);
        VpcTunnelUtils.getInstance();
        int result = VpcTunnelUtils.getvip(VpcTunnelUtils.getSocketFd(ctx), vtoa);
        if (result == 0 && vtoa != null) {
            log.debug("Get tunnel_id from vtoa success: resultCode={}, vid={}, vaddr={}, vport={}", result, vtoa.getVid(), vtoa.getVaddr(), vtoa.getVport());
        } else {
            log.debug("Get tunnel_id from vtoa error: resultCode={}, vid={}, vaddr={}, vport={}", result, vtoa.getVid(), vtoa.getVaddr(), vtoa.getVport());
        }
        return vtoa;
    }

    private static int getSocketFd(ChannelHandlerContext ctx) {
        try {
            NioSocketChannel nioChannel = (NioSocketChannel)ctx.channel();
            Field configField = nioChannel.getClass().getDeclaredField("config");
            configField.setAccessible(true);
            Object configValue = configField.get(nioChannel);
            configField.set(nioChannel, configValue);
            DefaultSocketChannelConfig config = (DefaultSocketChannelConfig)configValue;
            Field socketField = config.getClass().getSuperclass().getDeclaredField("javaSocket");
            socketField.setAccessible(true);
            Object socketValue = socketField.get(config);
            socketField.set(config, socketValue);
            Socket socket = (Socket)socketValue;
            SocketChannel socketChannel = socket.getChannel();
            Field fileDescriptorField = socketChannel.getClass().getDeclaredField("fd");
            fileDescriptorField.setAccessible(true);
            Object fileDescriptorValue = fileDescriptorField.get(socketChannel);
            fileDescriptorField.set(socketChannel, fileDescriptorValue);
            FileDescriptor fileDescriptor = (FileDescriptor)fileDescriptorValue;
            Field fdField = fileDescriptor.getClass().getDeclaredField("fd");
            fdField.setAccessible(true);
            Object fdValue = fdField.get(fileDescriptor);
            fdField.set(fileDescriptor, fdValue);
            return (Integer)fdValue;
        }
        catch (NoSuchFieldException e) {
            log.error("Get socket field failed. ", e);
        }
        catch (IllegalAccessException e) {
            log.error("Get socket field failed. ", e);
        }
        return 0;
    }

    static {
        System.loadLibrary("getvip");
        instance = new VpcTunnelUtils();
    }
}

