/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import java.nio.ByteBuffer;
import java.util.List;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.PullResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.PullStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.PullMessageResponseHeader;

public class PullResultExt extends PullResult {
    private final long suggestWhichBrokerId;
    private ByteBuffer messageBinary;

    private final PullMessageResponseHeader header;

    public PullResultExt(PullStatus pullStatus, PullMessageResponseHeader header,
        List<MessageExt> msgFoundList, ByteBuffer messageBinary) {
        super(pullStatus, header.getNextBeginOffset(), header.getMinOffset(), header.getMaxOffset(), msgFoundList);
        this.suggestWhichBrokerId = header.getSuggestWhichBrokerId();
        this.messageBinary = messageBinary;
        this.header = header;
    }

    public ByteBuffer getMessageBinary() {
        return messageBinary;
    }

    public void setMessageBinary(ByteBuffer messageBinary) {
        this.messageBinary = messageBinary;
    }

    public long getSuggestWhichBrokerId() {
        return suggestWhichBrokerId;
    }

    public PullMessageResponseHeader getHeader() {
        return header;
    }

}
