/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.core.task;

import com.aliyun.openservices.ots.internal.streamclient.core.task.ITask;
import com.aliyun.openservices.ots.internal.streamclient.core.task.TaskResult;
import com.aliyun.openservices.ots.internal.streamclient.core.task.TaskType;
import com.aliyun.openservices.ots.internal.streamclient.lease.ShardLease;
import com.aliyun.openservices.ots.internal.streamclient.lease.interfaces.ILeaseManager;
import com.aliyun.openservices.ots.internal.streamclient.model.ICheckpointTracker;
import com.aliyun.openservices.ots.internal.streamclient.model.ShardInfo;
import com.aliyun.openservices.ots.internal.streamclient.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockOnParentShardTask
implements ITask {
    private static final Logger LOG = LoggerFactory.getLogger(BlockOnParentShardTask.class);
    private final ShardInfo shardInfo;
    private final ILeaseManager<ShardLease> leaseManager;
    private ICheckpointTracker checkpointTracker;
    private final long parentShardPollIntervalMillis;

    public BlockOnParentShardTask(ShardInfo shardInfo, ILeaseManager<ShardLease> leaseManager, ICheckpointTracker checkpointTracker, long parentShardPollIntervalMillis) {
        this.shardInfo = shardInfo;
        this.leaseManager = leaseManager;
        this.checkpointTracker = checkpointTracker;
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
    }

    @Override
    public TaskResult call() {
        LOG.debug("Start, ShardId: {}, ParentIds: {}.", (Object)this.shardInfo.getShardId(), this.shardInfo.getParentShardIds());
        try {
            for (String shardId : this.shardInfo.getParentShardIds()) {
                ShardLease lease = this.leaseManager.getLease(shardId);
                if (lease != null) {
                    String checkpoint = this.checkpointTracker.getCheckpoint(shardId);
                    if (checkpoint != null && checkpoint.equals("SHARD_END")) continue;
                    TimeUtils.sleepMillis(this.parentShardPollIntervalMillis);
                    LOG.debug("Parent shard not complete, ShardId: {}, ParentId: {}, Checkpoint: {}.", new Object[]{this.shardInfo.getShardId(), shardId, checkpoint});
                    return new TaskResult(false);
                }
                LOG.info("No lease found for parent shard: {}.", (Object)shardId);
            }
            LOG.info("Parent shard complete, ShardId: {}.", (Object)this.shardInfo.getShardId());
            return new TaskResult(true);
        }
        catch (Exception e) {
            LOG.warn("ShardId: {}, Exception: {}.", (Object)this.shardInfo.getShardId(), (Object)e);
            return new TaskResult(e);
        }
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.BLOCK_ON_PARENT_SHARDS;
    }
}

