/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.lease;

import com.aliyun.openservices.ots.internal.streamclient.DependencyException;
import com.aliyun.openservices.ots.internal.streamclient.model.IRetryStrategy;

public class LeaseManagerRetryStrategy
implements IRetryStrategy {
    private int maxRetries = 10;
    private long minBackoffTimeMillis = 100L;
    private long maxBackoffTimeMillis = 1000L;

    @Override
    public boolean shouldRetry(IRetryStrategy.RetryableAction actionName, Exception ex, int retries) {
        if (retries >= this.maxRetries) {
            return false;
        }
        return ex instanceof DependencyException;
    }

    @Override
    public long getBackoffTimeMillis(IRetryStrategy.RetryableAction actionName, Exception ex, int retries) {
        long backoffTimeMillis = this.minBackoffTimeMillis * (long)(retries + 1);
        backoffTimeMillis = Math.min(backoffTimeMillis, this.maxBackoffTimeMillis);
        return backoffTimeMillis;
    }
}

