/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl;

import com.amazon.ion.IonBinaryWriter;
import com.amazon.ion.IonCatalog;
import com.amazon.ion.IonException;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonWriter;
import com.amazon.ion.SubstituteSymbolTableException;
import com.amazon.ion.SymbolTable;
import com.amazon.ion.ValueFactory;
import com.amazon.ion.impl.BlockedBuffer;
import com.amazon.ion.impl.IonWriterSystemBinary;
import com.amazon.ion.impl.LocalSymbolTable;
import com.amazon.ion.impl._Private_IonBinaryWriterImpl;
import com.amazon.ion.impl._Private_Utils;
import com.amazon.ion.impl.bin._Private_IonManagedBinaryWriterBuilder;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.amazon.ion.system.IonSystemBuilder;
import java.io.IOException;
import java.io.OutputStream;

public class _Private_IonBinaryWriterBuilder
extends IonBinaryWriterBuilder {
    private final _Private_IonManagedBinaryWriterBuilder myBinaryWriterBuilder;
    private ValueFactory mySymtabValueFactory;
    private SymbolTable myInitialSymbolTable;

    private _Private_IonBinaryWriterBuilder() {
        this.myBinaryWriterBuilder = _Private_IonManagedBinaryWriterBuilder.create(_Private_IonManagedBinaryWriterBuilder.AllocatorMode.POOLED).withPaddedLengthPreallocation(0);
    }

    private _Private_IonBinaryWriterBuilder(_Private_IonBinaryWriterBuilder that) {
        super(that);
        this.mySymtabValueFactory = that.mySymtabValueFactory;
        this.myInitialSymbolTable = that.myInitialSymbolTable;
        this.myBinaryWriterBuilder = that.myBinaryWriterBuilder.copy();
    }

    public static _Private_IonBinaryWriterBuilder standard() {
        return new Mutable();
    }

    public final _Private_IonBinaryWriterBuilder copy() {
        return new Mutable(this);
    }

    public _Private_IonBinaryWriterBuilder immutable() {
        return this;
    }

    public _Private_IonBinaryWriterBuilder mutable() {
        return this.copy();
    }

    public ValueFactory getSymtabValueFactory() {
        return this.mySymtabValueFactory;
    }

    public void setSymtabValueFactory(ValueFactory factory) {
        this.mutationCheck();
        this.mySymtabValueFactory = factory;
    }

    public _Private_IonBinaryWriterBuilder withSymtabValueFactory(ValueFactory factory) {
        _Private_IonBinaryWriterBuilder b = this.mutable();
        b.setSymtabValueFactory(factory);
        return b;
    }

    public SymbolTable getInitialSymbolTable() {
        return this.myInitialSymbolTable;
    }

    public void setInitialSymbolTable(SymbolTable symtab) {
        this.mutationCheck();
        if (symtab != null) {
            if (symtab.isLocalTable()) {
                SymbolTable[] imports;
                for (SymbolTable imported : imports = ((LocalSymbolTable)symtab).getImportedTablesNoCopy()) {
                    if (!imported.isSubstitute()) continue;
                    String message = "Cannot encode with substitute symbol table: " + imported.getName();
                    throw new SubstituteSymbolTableException(message);
                }
            } else if (!symtab.isSystemTable()) {
                String message = "symtab must be local or system table";
                throw new IllegalArgumentException(message);
            }
        }
        this.myInitialSymbolTable = symtab;
        this.myBinaryWriterBuilder.withInitialSymbolTable(symtab);
    }

    public _Private_IonBinaryWriterBuilder withInitialSymbolTable(SymbolTable symtab) {
        _Private_IonBinaryWriterBuilder b = this.mutable();
        b.setInitialSymbolTable(symtab);
        return b;
    }

    public void setIsFloatBinary32Enabled(boolean enabled) {
        this.mutationCheck();
        if (enabled) {
            this.myBinaryWriterBuilder.withFloatBinary32Enabled();
        } else {
            this.myBinaryWriterBuilder.withFloatBinary32Disabled();
        }
    }

    public _Private_IonBinaryWriterBuilder withFloatBinary32Enabled() {
        _Private_IonBinaryWriterBuilder b = this.mutable();
        b.setIsFloatBinary32Enabled(true);
        return b;
    }

    public _Private_IonBinaryWriterBuilder withFloatBinary32Disabled() {
        _Private_IonBinaryWriterBuilder b = this.mutable();
        b.setIsFloatBinary32Enabled(false);
        return b;
    }

    public void setImports(SymbolTable ... imports) {
        super.setImports(imports);
        this.myBinaryWriterBuilder.withImports(imports);
    }

    public void setCatalog(IonCatalog catalog) {
        super.setCatalog(catalog);
        this.myBinaryWriterBuilder.withCatalog(catalog);
    }

    public void setStreamCopyOptimized(boolean optimized) {
        super.setStreamCopyOptimized(optimized);
        this.myBinaryWriterBuilder.withStreamCopyOptimization(optimized);
    }

    private _Private_IonBinaryWriterBuilder fillDefaults() {
        _Private_IonBinaryWriterBuilder b = this.copy();
        if (b.getSymtabValueFactory() == null) {
            IonSystem system = IonSystemBuilder.standard().build();
            b.setSymtabValueFactory(system);
        }
        return b.immutable();
    }

    private _Private_IonBinaryWriterBuilder fillLegacyDefaults() {
        SymbolTable initialSymtab;
        _Private_IonBinaryWriterBuilder b = this.copy();
        if (b.getSymtabValueFactory() == null) {
            IonSystem system = IonSystemBuilder.standard().build();
            b.setSymtabValueFactory(system);
        }
        if ((initialSymtab = b.getInitialSymbolTable()) == null) {
            initialSymtab = _Private_Utils.initialSymtab(LocalSymbolTable.DEFAULT_LST_FACTORY, _Private_Utils.systemSymtab(1), b.getImports());
            b.setInitialSymbolTable(initialSymtab);
        } else if (initialSymtab.isSystemTable()) {
            initialSymtab = _Private_Utils.initialSymtab(LocalSymbolTable.DEFAULT_LST_FACTORY, initialSymtab, b.getImports());
            b.setInitialSymbolTable(initialSymtab);
        }
        return b.immutable();
    }

    private IonWriterSystemBinary buildSystemWriter(OutputStream out) {
        SymbolTable defaultSystemSymtab = this.myInitialSymbolTable.getSystemSymbolTable();
        return new IonWriterSystemBinary(defaultSystemSymtab, out, false, true);
    }

    SymbolTable buildContextSymbolTable() {
        if (this.myInitialSymbolTable.isReadOnly()) {
            return this.myInitialSymbolTable;
        }
        return ((LocalSymbolTable)this.myInitialSymbolTable).makeCopy();
    }

    public final IonWriter build(OutputStream out) {
        _Private_IonBinaryWriterBuilder b = this.fillDefaults();
        try {
            return b.myBinaryWriterBuilder.newWriter(out);
        }
        catch (IOException e) {
            throw new IonException("I/O Error", e);
        }
    }

    @Deprecated
    public final IonBinaryWriter buildLegacy() {
        _Private_IonBinaryWriterBuilder b = this.fillLegacyDefaults();
        IonWriterSystemBinary systemWriter = b.buildSystemWriter(new BlockedBuffer.BufferedOutputStream());
        return new _Private_IonBinaryWriterImpl(b, systemWriter);
    }

    private static final class Mutable
    extends _Private_IonBinaryWriterBuilder {
        private Mutable() {
        }

        private Mutable(_Private_IonBinaryWriterBuilder that) {
            super(that);
        }

        public _Private_IonBinaryWriterBuilder immutable() {
            return new _Private_IonBinaryWriterBuilder(this);
        }

        public _Private_IonBinaryWriterBuilder mutable() {
            return this;
        }

        protected void mutationCheck() {
        }
    }
}

