/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apigateway.model.EndpointType;
import com.amazonaws.services.apigateway.model.transform.EndpointConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EndpointConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> types;
    private List<String> vpcEndpointIds;

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<String> types) {
        if (types == null) {
            this.types = null;
            return;
        }
        this.types = new ArrayList<String>(types);
    }

    public EndpointConfiguration withTypes(String ... types) {
        if (this.types == null) {
            this.setTypes(new ArrayList<String>(types.length));
        }
        for (String ele : types) {
            this.types.add(ele);
        }
        return this;
    }

    public EndpointConfiguration withTypes(Collection<String> types) {
        this.setTypes(types);
        return this;
    }

    public EndpointConfiguration withTypes(EndpointType ... types) {
        ArrayList<String> typesCopy = new ArrayList<String>(types.length);
        for (EndpointType value : types) {
            typesCopy.add(value.toString());
        }
        if (this.getTypes() == null) {
            this.setTypes(typesCopy);
        } else {
            this.getTypes().addAll(typesCopy);
        }
        return this;
    }

    public List<String> getVpcEndpointIds() {
        return this.vpcEndpointIds;
    }

    public void setVpcEndpointIds(Collection<String> vpcEndpointIds) {
        if (vpcEndpointIds == null) {
            this.vpcEndpointIds = null;
            return;
        }
        this.vpcEndpointIds = new ArrayList<String>(vpcEndpointIds);
    }

    public EndpointConfiguration withVpcEndpointIds(String ... vpcEndpointIds) {
        if (this.vpcEndpointIds == null) {
            this.setVpcEndpointIds(new ArrayList<String>(vpcEndpointIds.length));
        }
        for (String ele : vpcEndpointIds) {
            this.vpcEndpointIds.add(ele);
        }
        return this;
    }

    public EndpointConfiguration withVpcEndpointIds(Collection<String> vpcEndpointIds) {
        this.setVpcEndpointIds(vpcEndpointIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTypes() != null) {
            sb.append("Types: ").append(this.getTypes()).append(",");
        }
        if (this.getVpcEndpointIds() != null) {
            sb.append("VpcEndpointIds: ").append(this.getVpcEndpointIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointConfiguration)) {
            return false;
        }
        EndpointConfiguration other = (EndpointConfiguration)obj;
        if (other.getTypes() == null ^ this.getTypes() == null) {
            return false;
        }
        if (other.getTypes() != null && !other.getTypes().equals(this.getTypes())) {
            return false;
        }
        if (other.getVpcEndpointIds() == null ^ this.getVpcEndpointIds() == null) {
            return false;
        }
        return other.getVpcEndpointIds() == null || other.getVpcEndpointIds().equals(this.getVpcEndpointIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTypes() == null ? 0 : this.getTypes().hashCode());
        hashCode = 31 * hashCode + (this.getVpcEndpointIds() == null ? 0 : this.getVpcEndpointIds().hashCode());
        return hashCode;
    }

    public EndpointConfiguration clone() {
        try {
            return (EndpointConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

