/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationautoscaling.model.ScalableTarget;

public class ScalableTargetJsonMarshaller {
    private static ScalableTargetJsonMarshaller instance;

    public void marshall(ScalableTarget scalableTarget, StructuredJsonGenerator jsonGenerator) {
        if (scalableTarget == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (scalableTarget.getServiceNamespace() != null) {
                jsonGenerator.writeFieldName("ServiceNamespace").writeValue(scalableTarget.getServiceNamespace());
            }
            if (scalableTarget.getResourceId() != null) {
                jsonGenerator.writeFieldName("ResourceId").writeValue(scalableTarget.getResourceId());
            }
            if (scalableTarget.getScalableDimension() != null) {
                jsonGenerator.writeFieldName("ScalableDimension").writeValue(scalableTarget.getScalableDimension());
            }
            if (scalableTarget.getMinCapacity() != null) {
                jsonGenerator.writeFieldName("MinCapacity").writeValue(scalableTarget.getMinCapacity().intValue());
            }
            if (scalableTarget.getMaxCapacity() != null) {
                jsonGenerator.writeFieldName("MaxCapacity").writeValue(scalableTarget.getMaxCapacity().intValue());
            }
            if (scalableTarget.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(scalableTarget.getRoleARN());
            }
            if (scalableTarget.getCreationTime() != null) {
                jsonGenerator.writeFieldName("CreationTime").writeValue(scalableTarget.getCreationTime());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ScalableTargetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ScalableTargetJsonMarshaller();
        }
        return instance;
    }
}

