/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.appstream.model.Application;
import java.util.Map;

public class ApplicationJsonMarshaller {
    private static ApplicationJsonMarshaller instance;

    public void marshall(Application application, StructuredJsonGenerator jsonGenerator) {
        if (application == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> metadataMap;
            jsonGenerator.writeStartObject();
            if (application.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(application.getName());
            }
            if (application.getDisplayName() != null) {
                jsonGenerator.writeFieldName("DisplayName").writeValue(application.getDisplayName());
            }
            if (application.getIconURL() != null) {
                jsonGenerator.writeFieldName("IconURL").writeValue(application.getIconURL());
            }
            if (application.getLaunchPath() != null) {
                jsonGenerator.writeFieldName("LaunchPath").writeValue(application.getLaunchPath());
            }
            if (application.getLaunchParameters() != null) {
                jsonGenerator.writeFieldName("LaunchParameters").writeValue(application.getLaunchParameters());
            }
            if (application.getEnabled() != null) {
                jsonGenerator.writeFieldName("Enabled").writeValue(application.getEnabled().booleanValue());
            }
            if ((metadataMap = application.getMetadata()) != null) {
                jsonGenerator.writeFieldName("Metadata");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> metadataMapValue : metadataMap.entrySet()) {
                    if (metadataMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(metadataMapValue.getKey());
                    jsonGenerator.writeValue(metadataMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ApplicationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ApplicationJsonMarshaller();
        }
        return instance;
    }
}

