/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.appstream.model.DescribeStacksRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class DescribeStacksRequestMarshaller
implements Marshaller<Request<DescribeStacksRequest>, DescribeStacksRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeStacksRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeStacksRequest> marshall(DescribeStacksRequest describeStacksRequest) {
        if (describeStacksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeStacksRequest, "AmazonAppStream");
        request.addHeader("X-Amz-Target", "PhotonAdminProxyService.DescribeStacks");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> namesList = describeStacksRequest.getNames();
            if (namesList != null) {
                jsonGenerator.writeFieldName("Names");
                jsonGenerator.writeStartArray();
                for (String namesListValue : namesList) {
                    if (namesListValue == null) continue;
                    jsonGenerator.writeValue(namesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeStacksRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeStacksRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

