/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.backup.model.FrameworkControl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateFrameworkRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String frameworkName;
    private String frameworkDescription;
    private List<FrameworkControl> frameworkControls;
    private String idempotencyToken;

    public void setFrameworkName(String frameworkName) {
        this.frameworkName = frameworkName;
    }

    public String getFrameworkName() {
        return this.frameworkName;
    }

    public UpdateFrameworkRequest withFrameworkName(String frameworkName) {
        this.setFrameworkName(frameworkName);
        return this;
    }

    public void setFrameworkDescription(String frameworkDescription) {
        this.frameworkDescription = frameworkDescription;
    }

    public String getFrameworkDescription() {
        return this.frameworkDescription;
    }

    public UpdateFrameworkRequest withFrameworkDescription(String frameworkDescription) {
        this.setFrameworkDescription(frameworkDescription);
        return this;
    }

    public List<FrameworkControl> getFrameworkControls() {
        return this.frameworkControls;
    }

    public void setFrameworkControls(Collection<FrameworkControl> frameworkControls) {
        if (frameworkControls == null) {
            this.frameworkControls = null;
            return;
        }
        this.frameworkControls = new ArrayList<FrameworkControl>(frameworkControls);
    }

    public UpdateFrameworkRequest withFrameworkControls(FrameworkControl ... frameworkControls) {
        if (this.frameworkControls == null) {
            this.setFrameworkControls(new ArrayList<FrameworkControl>(frameworkControls.length));
        }
        for (FrameworkControl ele : frameworkControls) {
            this.frameworkControls.add(ele);
        }
        return this;
    }

    public UpdateFrameworkRequest withFrameworkControls(Collection<FrameworkControl> frameworkControls) {
        this.setFrameworkControls(frameworkControls);
        return this;
    }

    public void setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public UpdateFrameworkRequest withIdempotencyToken(String idempotencyToken) {
        this.setIdempotencyToken(idempotencyToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFrameworkName() != null) {
            sb.append("FrameworkName: ").append(this.getFrameworkName()).append(",");
        }
        if (this.getFrameworkDescription() != null) {
            sb.append("FrameworkDescription: ").append(this.getFrameworkDescription()).append(",");
        }
        if (this.getFrameworkControls() != null) {
            sb.append("FrameworkControls: ").append(this.getFrameworkControls()).append(",");
        }
        if (this.getIdempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.getIdempotencyToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFrameworkRequest)) {
            return false;
        }
        UpdateFrameworkRequest other = (UpdateFrameworkRequest)obj;
        if (other.getFrameworkName() == null ^ this.getFrameworkName() == null) {
            return false;
        }
        if (other.getFrameworkName() != null && !other.getFrameworkName().equals(this.getFrameworkName())) {
            return false;
        }
        if (other.getFrameworkDescription() == null ^ this.getFrameworkDescription() == null) {
            return false;
        }
        if (other.getFrameworkDescription() != null && !other.getFrameworkDescription().equals(this.getFrameworkDescription())) {
            return false;
        }
        if (other.getFrameworkControls() == null ^ this.getFrameworkControls() == null) {
            return false;
        }
        if (other.getFrameworkControls() != null && !other.getFrameworkControls().equals(this.getFrameworkControls())) {
            return false;
        }
        if (other.getIdempotencyToken() == null ^ this.getIdempotencyToken() == null) {
            return false;
        }
        return other.getIdempotencyToken() == null || other.getIdempotencyToken().equals(this.getIdempotencyToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFrameworkName() == null ? 0 : this.getFrameworkName().hashCode());
        hashCode = 31 * hashCode + (this.getFrameworkDescription() == null ? 0 : this.getFrameworkDescription().hashCode());
        hashCode = 31 * hashCode + (this.getFrameworkControls() == null ? 0 : this.getFrameworkControls().hashCode());
        hashCode = 31 * hashCode + (this.getIdempotencyToken() == null ? 0 : this.getIdempotencyToken().hashCode());
        return hashCode;
    }

    public UpdateFrameworkRequest clone() {
        return (UpdateFrameworkRequest)super.clone();
    }
}

