/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmediapipelines.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chimesdkmediapipelines.model.MediaEncoding;
import com.amazonaws.services.chimesdkmediapipelines.model.StreamConfiguration;
import com.amazonaws.services.chimesdkmediapipelines.model.transform.KinesisVideoStreamSourceRuntimeConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KinesisVideoStreamSourceRuntimeConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<StreamConfiguration> streams;
    private String mediaEncoding;
    private Integer mediaSampleRate;

    public List<StreamConfiguration> getStreams() {
        return this.streams;
    }

    public void setStreams(Collection<StreamConfiguration> streams) {
        if (streams == null) {
            this.streams = null;
            return;
        }
        this.streams = new ArrayList<StreamConfiguration>(streams);
    }

    public KinesisVideoStreamSourceRuntimeConfiguration withStreams(StreamConfiguration ... streams) {
        if (this.streams == null) {
            this.setStreams(new ArrayList<StreamConfiguration>(streams.length));
        }
        for (StreamConfiguration ele : streams) {
            this.streams.add(ele);
        }
        return this;
    }

    public KinesisVideoStreamSourceRuntimeConfiguration withStreams(Collection<StreamConfiguration> streams) {
        this.setStreams(streams);
        return this;
    }

    public void setMediaEncoding(String mediaEncoding) {
        this.mediaEncoding = mediaEncoding;
    }

    public String getMediaEncoding() {
        return this.mediaEncoding;
    }

    public KinesisVideoStreamSourceRuntimeConfiguration withMediaEncoding(String mediaEncoding) {
        this.setMediaEncoding(mediaEncoding);
        return this;
    }

    public KinesisVideoStreamSourceRuntimeConfiguration withMediaEncoding(MediaEncoding mediaEncoding) {
        this.mediaEncoding = mediaEncoding.toString();
        return this;
    }

    public void setMediaSampleRate(Integer mediaSampleRate) {
        this.mediaSampleRate = mediaSampleRate;
    }

    public Integer getMediaSampleRate() {
        return this.mediaSampleRate;
    }

    public KinesisVideoStreamSourceRuntimeConfiguration withMediaSampleRate(Integer mediaSampleRate) {
        this.setMediaSampleRate(mediaSampleRate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreams() != null) {
            sb.append("Streams: ").append(this.getStreams()).append(",");
        }
        if (this.getMediaEncoding() != null) {
            sb.append("MediaEncoding: ").append(this.getMediaEncoding()).append(",");
        }
        if (this.getMediaSampleRate() != null) {
            sb.append("MediaSampleRate: ").append(this.getMediaSampleRate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamSourceRuntimeConfiguration)) {
            return false;
        }
        KinesisVideoStreamSourceRuntimeConfiguration other = (KinesisVideoStreamSourceRuntimeConfiguration)obj;
        if (other.getStreams() == null ^ this.getStreams() == null) {
            return false;
        }
        if (other.getStreams() != null && !other.getStreams().equals(this.getStreams())) {
            return false;
        }
        if (other.getMediaEncoding() == null ^ this.getMediaEncoding() == null) {
            return false;
        }
        if (other.getMediaEncoding() != null && !other.getMediaEncoding().equals(this.getMediaEncoding())) {
            return false;
        }
        if (other.getMediaSampleRate() == null ^ this.getMediaSampleRate() == null) {
            return false;
        }
        return other.getMediaSampleRate() == null || other.getMediaSampleRate().equals(this.getMediaSampleRate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreams() == null ? 0 : this.getStreams().hashCode());
        hashCode = 31 * hashCode + (this.getMediaEncoding() == null ? 0 : this.getMediaEncoding().hashCode());
        hashCode = 31 * hashCode + (this.getMediaSampleRate() == null ? 0 : this.getMediaSampleRate().hashCode());
        return hashCode;
    }

    public KinesisVideoStreamSourceRuntimeConfiguration clone() {
        try {
            return (KinesisVideoStreamSourceRuntimeConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisVideoStreamSourceRuntimeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

