/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudtrail.model.Resource;
import com.amazonaws.services.cloudtrail.model.transform.EventMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Event
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventId;
    private String eventName;
    private String readOnly;
    private String accessKeyId;
    private Date eventTime;
    private String eventSource;
    private String username;
    private SdkInternalList<Resource> resources;
    private String cloudTrailEvent;

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Event withEventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public Event withEventName(String eventName) {
        this.setEventName(eventName);
        return this;
    }

    public void setReadOnly(String readOnly) {
        this.readOnly = readOnly;
    }

    public String getReadOnly() {
        return this.readOnly;
    }

    public Event withReadOnly(String readOnly) {
        this.setReadOnly(readOnly);
        return this;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public Event withAccessKeyId(String accessKeyId) {
        this.setAccessKeyId(accessKeyId);
        return this;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public Event withEventTime(Date eventTime) {
        this.setEventTime(eventTime);
        return this;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public Event withEventSource(String eventSource) {
        this.setEventSource(eventSource);
        return this;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public Event withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public List<Resource> getResources() {
        if (this.resources == null) {
            this.resources = new SdkInternalList();
        }
        return this.resources;
    }

    public void setResources(Collection<Resource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new SdkInternalList(resources);
    }

    public Event withResources(Resource ... resources) {
        if (this.resources == null) {
            this.setResources((Collection<Resource>)new SdkInternalList(resources.length));
        }
        for (Resource ele : resources) {
            this.resources.add((Object)ele);
        }
        return this;
    }

    public Event withResources(Collection<Resource> resources) {
        this.setResources(resources);
        return this;
    }

    public void setCloudTrailEvent(String cloudTrailEvent) {
        this.cloudTrailEvent = cloudTrailEvent;
    }

    public String getCloudTrailEvent() {
        return this.cloudTrailEvent;
    }

    public Event withCloudTrailEvent(String cloudTrailEvent) {
        this.setCloudTrailEvent(cloudTrailEvent);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventId() != null) {
            sb.append("EventId: ").append(this.getEventId()).append(",");
        }
        if (this.getEventName() != null) {
            sb.append("EventName: ").append(this.getEventName()).append(",");
        }
        if (this.getReadOnly() != null) {
            sb.append("ReadOnly: ").append(this.getReadOnly()).append(",");
        }
        if (this.getAccessKeyId() != null) {
            sb.append("AccessKeyId: ").append(this.getAccessKeyId()).append(",");
        }
        if (this.getEventTime() != null) {
            sb.append("EventTime: ").append(this.getEventTime()).append(",");
        }
        if (this.getEventSource() != null) {
            sb.append("EventSource: ").append(this.getEventSource()).append(",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: ").append(this.getUsername()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getCloudTrailEvent() != null) {
            sb.append("CloudTrailEvent: ").append(this.getCloudTrailEvent());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getEventName() == null ^ this.getEventName() == null) {
            return false;
        }
        if (other.getEventName() != null && !other.getEventName().equals(this.getEventName())) {
            return false;
        }
        if (other.getReadOnly() == null ^ this.getReadOnly() == null) {
            return false;
        }
        if (other.getReadOnly() != null && !other.getReadOnly().equals(this.getReadOnly())) {
            return false;
        }
        if (other.getAccessKeyId() == null ^ this.getAccessKeyId() == null) {
            return false;
        }
        if (other.getAccessKeyId() != null && !other.getAccessKeyId().equals(this.getAccessKeyId())) {
            return false;
        }
        if (other.getEventTime() == null ^ this.getEventTime() == null) {
            return false;
        }
        if (other.getEventTime() != null && !other.getEventTime().equals(this.getEventTime())) {
            return false;
        }
        if (other.getEventSource() == null ^ this.getEventSource() == null) {
            return false;
        }
        if (other.getEventSource() != null && !other.getEventSource().equals(this.getEventSource())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getCloudTrailEvent() == null ^ this.getCloudTrailEvent() == null) {
            return false;
        }
        return other.getCloudTrailEvent() == null || other.getCloudTrailEvent().equals(this.getCloudTrailEvent());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getEventName() == null ? 0 : this.getEventName().hashCode());
        hashCode = 31 * hashCode + (this.getReadOnly() == null ? 0 : this.getReadOnly().hashCode());
        hashCode = 31 * hashCode + (this.getAccessKeyId() == null ? 0 : this.getAccessKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getEventTime() == null ? 0 : this.getEventTime().hashCode());
        hashCode = 31 * hashCode + (this.getEventSource() == null ? 0 : this.getEventSource().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getCloudTrailEvent() == null ? 0 : this.getCloudTrailEvent().hashCode());
        return hashCode;
    }

    public Event clone() {
        try {
            return (Event)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

