/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.GetPipelineExecutionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetPipelineExecutionRequestMarshaller
implements Marshaller<Request<GetPipelineExecutionRequest>, GetPipelineExecutionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetPipelineExecutionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetPipelineExecutionRequest> marshall(GetPipelineExecutionRequest getPipelineExecutionRequest) {
        if (getPipelineExecutionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getPipelineExecutionRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.GetPipelineExecution");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getPipelineExecutionRequest.getPipelineName() != null) {
                jsonGenerator.writeFieldName("pipelineName").writeValue(getPipelineExecutionRequest.getPipelineName());
            }
            if (getPipelineExecutionRequest.getPipelineExecutionId() != null) {
                jsonGenerator.writeFieldName("pipelineExecutionId").writeValue(getPipelineExecutionRequest.getPipelineExecutionId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

