/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.BlockType;
import com.amazonaws.services.comprehend.model.Geometry;
import com.amazonaws.services.comprehend.model.RelationshipsListItem;
import com.amazonaws.services.comprehend.model.transform.BlockMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Block
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String blockType;
    private String text;
    private Integer page;
    private Geometry geometry;
    private List<RelationshipsListItem> relationships;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Block withId(String id) {
        this.setId(id);
        return this;
    }

    public void setBlockType(String blockType) {
        this.blockType = blockType;
    }

    public String getBlockType() {
        return this.blockType;
    }

    public Block withBlockType(String blockType) {
        this.setBlockType(blockType);
        return this;
    }

    public Block withBlockType(BlockType blockType) {
        this.blockType = blockType.toString();
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public Block withText(String text) {
        this.setText(text);
        return this;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPage() {
        return this.page;
    }

    public Block withPage(Integer page) {
        this.setPage(page);
        return this;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public Block withGeometry(Geometry geometry) {
        this.setGeometry(geometry);
        return this;
    }

    public List<RelationshipsListItem> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(Collection<RelationshipsListItem> relationships) {
        if (relationships == null) {
            this.relationships = null;
            return;
        }
        this.relationships = new ArrayList<RelationshipsListItem>(relationships);
    }

    public Block withRelationships(RelationshipsListItem ... relationships) {
        if (this.relationships == null) {
            this.setRelationships(new ArrayList<RelationshipsListItem>(relationships.length));
        }
        for (RelationshipsListItem ele : relationships) {
            this.relationships.add(ele);
        }
        return this;
    }

    public Block withRelationships(Collection<RelationshipsListItem> relationships) {
        this.setRelationships(relationships);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getBlockType() != null) {
            sb.append("BlockType: ").append(this.getBlockType()).append(",");
        }
        if (this.getText() != null) {
            sb.append("Text: ").append(this.getText()).append(",");
        }
        if (this.getPage() != null) {
            sb.append("Page: ").append(this.getPage()).append(",");
        }
        if (this.getGeometry() != null) {
            sb.append("Geometry: ").append(this.getGeometry()).append(",");
        }
        if (this.getRelationships() != null) {
            sb.append("Relationships: ").append(this.getRelationships());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        Block other = (Block)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getBlockType() == null ^ this.getBlockType() == null) {
            return false;
        }
        if (other.getBlockType() != null && !other.getBlockType().equals(this.getBlockType())) {
            return false;
        }
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        if (other.getText() != null && !other.getText().equals(this.getText())) {
            return false;
        }
        if (other.getPage() == null ^ this.getPage() == null) {
            return false;
        }
        if (other.getPage() != null && !other.getPage().equals(this.getPage())) {
            return false;
        }
        if (other.getGeometry() == null ^ this.getGeometry() == null) {
            return false;
        }
        if (other.getGeometry() != null && !other.getGeometry().equals(this.getGeometry())) {
            return false;
        }
        if (other.getRelationships() == null ^ this.getRelationships() == null) {
            return false;
        }
        return other.getRelationships() == null || other.getRelationships().equals(this.getRelationships());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getBlockType() == null ? 0 : this.getBlockType().hashCode());
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        hashCode = 31 * hashCode + (this.getPage() == null ? 0 : this.getPage().hashCode());
        hashCode = 31 * hashCode + (this.getGeometry() == null ? 0 : this.getGeometry().hashCode());
        hashCode = 31 * hashCode + (this.getRelationships() == null ? 0 : this.getRelationships().hashCode());
        return hashCode;
    }

    public Block clone() {
        try {
            return (Block)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlockMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

