/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.databasemigrationservice.model.Recommendation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeRecommendationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<Recommendation> recommendations;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeRecommendationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Recommendation> getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(Collection<Recommendation> recommendations) {
        if (recommendations == null) {
            this.recommendations = null;
            return;
        }
        this.recommendations = new ArrayList<Recommendation>(recommendations);
    }

    public DescribeRecommendationsResult withRecommendations(Recommendation ... recommendations) {
        if (this.recommendations == null) {
            this.setRecommendations(new ArrayList<Recommendation>(recommendations.length));
        }
        for (Recommendation ele : recommendations) {
            this.recommendations.add(ele);
        }
        return this;
    }

    public DescribeRecommendationsResult withRecommendations(Collection<Recommendation> recommendations) {
        this.setRecommendations(recommendations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRecommendations() != null) {
            sb.append("Recommendations: ").append(this.getRecommendations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecommendationsResult)) {
            return false;
        }
        DescribeRecommendationsResult other = (DescribeRecommendationsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRecommendations() == null ^ this.getRecommendations() == null) {
            return false;
        }
        return other.getRecommendations() == null || other.getRecommendations().equals(this.getRecommendations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendations() == null ? 0 : this.getRecommendations().hashCode());
        return hashCode;
    }

    public DescribeRecommendationsResult clone() {
        try {
            return (DescribeRecommendationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

