/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class AttributeValueJsonMarshaller {
    private static AttributeValueJsonMarshaller instance;

    public void marshall(AttributeValue attributeValue, StructuredJsonGenerator jsonGenerator) {
        if (attributeValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<AttributeValue> list;
            Map<String, AttributeValue> map;
            List<ByteBuffer> list2;
            List<String> nSList;
            List<String> sSList;
            jsonGenerator.writeStartObject();
            if (attributeValue.getS() != null) {
                jsonGenerator.writeFieldName("S").writeValue(attributeValue.getS());
            }
            if (attributeValue.getN() != null) {
                jsonGenerator.writeFieldName("N").writeValue(attributeValue.getN());
            }
            if (attributeValue.getB() != null) {
                jsonGenerator.writeFieldName("B").writeValue(attributeValue.getB());
            }
            if ((sSList = attributeValue.getSS()) != null) {
                jsonGenerator.writeFieldName("SS");
                jsonGenerator.writeStartArray();
                for (String string : sSList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((nSList = attributeValue.getNS()) != null) {
                jsonGenerator.writeFieldName("NS");
                jsonGenerator.writeStartArray();
                for (String string : nSList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list2 = attributeValue.getBS()) != null) {
                jsonGenerator.writeFieldName("BS");
                jsonGenerator.writeStartArray();
                for (ByteBuffer byteBuffer : list2) {
                    if (byteBuffer == null) continue;
                    jsonGenerator.writeValue(byteBuffer);
                }
                jsonGenerator.writeEndArray();
            }
            if ((map = attributeValue.getM()) != null) {
                jsonGenerator.writeFieldName("M");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> entry : map.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(entry.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if ((list = attributeValue.getL()) != null) {
                jsonGenerator.writeFieldName("L");
                jsonGenerator.writeStartArray();
                for (AttributeValue lListValue : list) {
                    if (lListValue == null) continue;
                    AttributeValueJsonMarshaller.getInstance().marshall(lListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (attributeValue.getNULL() != null) {
                jsonGenerator.writeFieldName("NULL").writeValue(attributeValue.getNULL().booleanValue());
            }
            if (attributeValue.getBOOL() != null) {
                jsonGenerator.writeFieldName("BOOL").writeValue(attributeValue.getBOOL().booleanValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AttributeValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttributeValueJsonMarshaller();
        }
        return instance;
    }
}

