/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.DhcpConfiguration;
import com.amazonaws.services.ec2.model.DhcpOptions;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.DhcpConfigurationStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class DhcpOptionsStaxUnmarshaller
implements Unmarshaller<DhcpOptions, StaxUnmarshallerContext> {
    private static DhcpOptionsStaxUnmarshaller instance;

    public DhcpOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        DhcpOptions dhcpOptions = new DhcpOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dhcpOptions;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("dhcpOptionsId", targetDepth)) {
                    dhcpOptions.setDhcpOptionsId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("dhcpConfigurationSet", targetDepth)) {
                    dhcpOptions.withDhcpConfigurations(new ArrayList<DhcpConfiguration>());
                    continue;
                }
                if (context.testExpression("dhcpConfigurationSet/item", targetDepth)) {
                    dhcpOptions.withDhcpConfigurations(DhcpConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    dhcpOptions.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                dhcpOptions.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dhcpOptions;
    }

    public static DhcpOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DhcpOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

