/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystem;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystemClientBuilder;
import com.amazonaws.services.elasticfilesystem.model.AmazonElasticFileSystemException;
import com.amazonaws.services.elasticfilesystem.model.BadRequestException;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemResult;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetResult;
import com.amazonaws.services.elasticfilesystem.model.CreateTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateTagsResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteMountTargetRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteMountTargetResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteTagsResult;
import com.amazonaws.services.elasticfilesystem.model.DependencyTimeoutException;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetSecurityGroupsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetSecurityGroupsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsResult;
import com.amazonaws.services.elasticfilesystem.model.FileSystemAlreadyExistsException;
import com.amazonaws.services.elasticfilesystem.model.FileSystemInUseException;
import com.amazonaws.services.elasticfilesystem.model.FileSystemLimitExceededException;
import com.amazonaws.services.elasticfilesystem.model.FileSystemNotFoundException;
import com.amazonaws.services.elasticfilesystem.model.IncorrectFileSystemLifeCycleStateException;
import com.amazonaws.services.elasticfilesystem.model.IncorrectMountTargetStateException;
import com.amazonaws.services.elasticfilesystem.model.InsufficientThroughputCapacityException;
import com.amazonaws.services.elasticfilesystem.model.InternalServerErrorException;
import com.amazonaws.services.elasticfilesystem.model.IpAddressInUseException;
import com.amazonaws.services.elasticfilesystem.model.ModifyMountTargetSecurityGroupsRequest;
import com.amazonaws.services.elasticfilesystem.model.ModifyMountTargetSecurityGroupsResult;
import com.amazonaws.services.elasticfilesystem.model.MountTargetConflictException;
import com.amazonaws.services.elasticfilesystem.model.MountTargetNotFoundException;
import com.amazonaws.services.elasticfilesystem.model.NetworkInterfaceLimitExceededException;
import com.amazonaws.services.elasticfilesystem.model.NoFreeAddressesInSubnetException;
import com.amazonaws.services.elasticfilesystem.model.SecurityGroupLimitExceededException;
import com.amazonaws.services.elasticfilesystem.model.SecurityGroupNotFoundException;
import com.amazonaws.services.elasticfilesystem.model.SubnetNotFoundException;
import com.amazonaws.services.elasticfilesystem.model.ThroughputLimitExceededException;
import com.amazonaws.services.elasticfilesystem.model.TooManyRequestsException;
import com.amazonaws.services.elasticfilesystem.model.UnsupportedAvailabilityZoneException;
import com.amazonaws.services.elasticfilesystem.model.UpdateFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.UpdateFileSystemResult;
import com.amazonaws.services.elasticfilesystem.model.transform.CreateFileSystemRequestProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.CreateFileSystemResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.CreateMountTargetRequestProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.CreateMountTargetResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.CreateTagsRequestProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.CreateTagsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DeleteFileSystemRequestProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DeleteFileSystemResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DeleteMountTargetRequestProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DeleteMountTargetResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DeleteTagsRequestProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DeleteTagsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeFileSystemsRequestProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeFileSystemsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeMountTargetSecurityGroupsRequestProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeMountTargetSecurityGroupsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeMountTargetsRequestProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeMountTargetsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeTagsRequestProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeTagsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.ModifyMountTargetSecurityGroupsRequestProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.ModifyMountTargetSecurityGroupsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.UpdateFileSystemRequestProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.UpdateFileSystemResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonElasticFileSystemClient
extends AmazonWebServiceClient
implements AmazonElasticFileSystem {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonElasticFileSystem.class);
    private static final String DEFAULT_SIGNING_NAME = "elasticfilesystem";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedAvailabilityZone").withModeledClass(UnsupportedAvailabilityZoneException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IpAddressInUse").withModeledClass(IpAddressInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MountTargetConflict").withModeledClass(MountTargetConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SecurityGroupNotFound").withModeledClass(SecurityGroupNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemInUse").withModeledClass(FileSystemInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemAlreadyExists").withModeledClass(FileSystemAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NetworkInterfaceLimitExceeded").withModeledClass(NetworkInterfaceLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IncorrectFileSystemLifeCycleState").withModeledClass(IncorrectFileSystemLifeCycleStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoFreeAddressesInSubnet").withModeledClass(NoFreeAddressesInSubnetException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemNotFound").withModeledClass(FileSystemNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientThroughputCapacity").withModeledClass(InsufficientThroughputCapacityException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MountTargetNotFound").withModeledClass(MountTargetNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetNotFound").withModeledClass(SubnetNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IncorrectMountTargetState").withModeledClass(IncorrectMountTargetStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SecurityGroupLimitExceeded").withModeledClass(SecurityGroupLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThroughputLimitExceeded").withModeledClass(ThroughputLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DependencyTimeout").withModeledClass(DependencyTimeoutException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequests").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemLimitExceeded").withModeledClass(FileSystemLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequest").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)).withBaseServiceExceptionClass(AmazonElasticFileSystemException.class));

    @Deprecated
    public AmazonElasticFileSystemClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonElasticFileSystemClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonElasticFileSystemClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonElasticFileSystemClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonElasticFileSystemClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonElasticFileSystemClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonElasticFileSystemClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonElasticFileSystemClientBuilder builder() {
        return AmazonElasticFileSystemClientBuilder.standard();
    }

    AmazonElasticFileSystemClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://elasticfilesystem.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elasticfilesystem/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/elasticfilesystem/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateFileSystemResult createFileSystem(CreateFileSystemRequest request) {
        request = (CreateFileSystemRequest)this.beforeClientExecution(request);
        return this.executeCreateFileSystem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateFileSystemResult executeCreateFileSystem(CreateFileSystemRequest createFileSystemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFileSystemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFileSystemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFileSystemRequestProtocolMarshaller(protocolFactory).marshall((CreateFileSystemRequest)super.beforeMarshalling((AmazonWebServiceRequest)createFileSystemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFileSystemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFileSystemResult createFileSystemResult = (CreateFileSystemResult)response.getAwsResponse();
            return createFileSystemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateMountTargetResult createMountTarget(CreateMountTargetRequest request) {
        request = (CreateMountTargetRequest)this.beforeClientExecution(request);
        return this.executeCreateMountTarget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMountTargetResult executeCreateMountTarget(CreateMountTargetRequest createMountTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMountTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMountTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMountTargetRequestProtocolMarshaller(protocolFactory).marshall((CreateMountTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createMountTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMountTargetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMountTargetResult createMountTargetResult = (CreateMountTargetResult)response.getAwsResponse();
            return createMountTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateTagsResult createTags(CreateTagsRequest request) {
        request = (CreateTagsRequest)this.beforeClientExecution(request);
        return this.executeCreateTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTagsResult executeCreateTags(CreateTagsRequest createTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTagsRequestProtocolMarshaller(protocolFactory).marshall((CreateTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)createTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTagsResult createTagsResult = (CreateTagsResult)response.getAwsResponse();
            return createTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteFileSystemResult deleteFileSystem(DeleteFileSystemRequest request) {
        request = (DeleteFileSystemRequest)this.beforeClientExecution(request);
        return this.executeDeleteFileSystem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteFileSystemResult executeDeleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFileSystemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFileSystemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFileSystemRequestProtocolMarshaller(protocolFactory).marshall((DeleteFileSystemRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteFileSystemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFileSystemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFileSystemResult deleteFileSystemResult = (DeleteFileSystemResult)response.getAwsResponse();
            return deleteFileSystemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMountTargetResult deleteMountTarget(DeleteMountTargetRequest request) {
        request = (DeleteMountTargetRequest)this.beforeClientExecution(request);
        return this.executeDeleteMountTarget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMountTargetResult executeDeleteMountTarget(DeleteMountTargetRequest deleteMountTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMountTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMountTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMountTargetRequestProtocolMarshaller(protocolFactory).marshall((DeleteMountTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMountTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMountTargetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMountTargetResult deleteMountTargetResult = (DeleteMountTargetResult)response.getAwsResponse();
            return deleteMountTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTagsResult deleteTags(DeleteTagsRequest request) {
        request = (DeleteTagsRequest)this.beforeClientExecution(request);
        return this.executeDeleteTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTagsResult executeDeleteTags(DeleteTagsRequest deleteTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTagsRequestProtocolMarshaller(protocolFactory).marshall((DeleteTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTagsResult deleteTagsResult = (DeleteTagsResult)response.getAwsResponse();
            return deleteTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFileSystemsResult describeFileSystems(DescribeFileSystemsRequest request) {
        request = (DescribeFileSystemsRequest)this.beforeClientExecution(request);
        return this.executeDescribeFileSystems(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFileSystemsResult executeDescribeFileSystems(DescribeFileSystemsRequest describeFileSystemsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFileSystemsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFileSystemsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFileSystemsRequestProtocolMarshaller(protocolFactory).marshall((DescribeFileSystemsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFileSystemsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFileSystemsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFileSystemsResult describeFileSystemsResult = (DescribeFileSystemsResult)response.getAwsResponse();
            return describeFileSystemsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFileSystemsResult describeFileSystems() {
        return this.describeFileSystems(new DescribeFileSystemsRequest());
    }

    @Override
    public DescribeMountTargetSecurityGroupsResult describeMountTargetSecurityGroups(DescribeMountTargetSecurityGroupsRequest request) {
        request = (DescribeMountTargetSecurityGroupsRequest)this.beforeClientExecution(request);
        return this.executeDescribeMountTargetSecurityGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeMountTargetSecurityGroupsResult executeDescribeMountTargetSecurityGroups(DescribeMountTargetSecurityGroupsRequest describeMountTargetSecurityGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeMountTargetSecurityGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeMountTargetSecurityGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeMountTargetSecurityGroupsRequestProtocolMarshaller(protocolFactory).marshall((DescribeMountTargetSecurityGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeMountTargetSecurityGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeMountTargetSecurityGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeMountTargetSecurityGroupsResult describeMountTargetSecurityGroupsResult = (DescribeMountTargetSecurityGroupsResult)response.getAwsResponse();
            return describeMountTargetSecurityGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeMountTargetsResult describeMountTargets(DescribeMountTargetsRequest request) {
        request = (DescribeMountTargetsRequest)this.beforeClientExecution(request);
        return this.executeDescribeMountTargets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeMountTargetsResult executeDescribeMountTargets(DescribeMountTargetsRequest describeMountTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeMountTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeMountTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeMountTargetsRequestProtocolMarshaller(protocolFactory).marshall((DescribeMountTargetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeMountTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeMountTargetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeMountTargetsResult describeMountTargetsResult = (DescribeMountTargetsResult)response.getAwsResponse();
            return describeMountTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTagsResult describeTags(DescribeTagsRequest request) {
        request = (DescribeTagsRequest)this.beforeClientExecution(request);
        return this.executeDescribeTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTagsResult executeDescribeTags(DescribeTagsRequest describeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTagsRequestProtocolMarshaller(protocolFactory).marshall((DescribeTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTagsResult describeTagsResult = (DescribeTagsResult)response.getAwsResponse();
            return describeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ModifyMountTargetSecurityGroupsResult modifyMountTargetSecurityGroups(ModifyMountTargetSecurityGroupsRequest request) {
        request = (ModifyMountTargetSecurityGroupsRequest)this.beforeClientExecution(request);
        return this.executeModifyMountTargetSecurityGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ModifyMountTargetSecurityGroupsResult executeModifyMountTargetSecurityGroups(ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyMountTargetSecurityGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyMountTargetSecurityGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyMountTargetSecurityGroupsRequestProtocolMarshaller(protocolFactory).marshall((ModifyMountTargetSecurityGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)modifyMountTargetSecurityGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ModifyMountTargetSecurityGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ModifyMountTargetSecurityGroupsResult modifyMountTargetSecurityGroupsResult = (ModifyMountTargetSecurityGroupsResult)response.getAwsResponse();
            return modifyMountTargetSecurityGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateFileSystemResult updateFileSystem(UpdateFileSystemRequest request) {
        request = (UpdateFileSystemRequest)this.beforeClientExecution(request);
        return this.executeUpdateFileSystem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateFileSystemResult executeUpdateFileSystem(UpdateFileSystemRequest updateFileSystemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFileSystemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFileSystemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFileSystemRequestProtocolMarshaller(protocolFactory).marshall((UpdateFileSystemRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFileSystemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFileSystemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFileSystemResult updateFileSystemResult = (UpdateFileSystemResult)response.getAwsResponse();
            return updateFileSystemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

