/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.ColumnSelector;
import com.amazonaws.services.gluedatabrew.model.StatisticsConfiguration;
import com.amazonaws.services.gluedatabrew.model.transform.ColumnStatisticsConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ColumnStatisticsConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ColumnSelector> selectors;
    private StatisticsConfiguration statistics;

    public List<ColumnSelector> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(Collection<ColumnSelector> selectors) {
        if (selectors == null) {
            this.selectors = null;
            return;
        }
        this.selectors = new ArrayList<ColumnSelector>(selectors);
    }

    public ColumnStatisticsConfiguration withSelectors(ColumnSelector ... selectors) {
        if (this.selectors == null) {
            this.setSelectors(new ArrayList<ColumnSelector>(selectors.length));
        }
        for (ColumnSelector ele : selectors) {
            this.selectors.add(ele);
        }
        return this;
    }

    public ColumnStatisticsConfiguration withSelectors(Collection<ColumnSelector> selectors) {
        this.setSelectors(selectors);
        return this;
    }

    public void setStatistics(StatisticsConfiguration statistics) {
        this.statistics = statistics;
    }

    public StatisticsConfiguration getStatistics() {
        return this.statistics;
    }

    public ColumnStatisticsConfiguration withStatistics(StatisticsConfiguration statistics) {
        this.setStatistics(statistics);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSelectors() != null) {
            sb.append("Selectors: ").append(this.getSelectors()).append(",");
        }
        if (this.getStatistics() != null) {
            sb.append("Statistics: ").append(this.getStatistics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnStatisticsConfiguration)) {
            return false;
        }
        ColumnStatisticsConfiguration other = (ColumnStatisticsConfiguration)obj;
        if (other.getSelectors() == null ^ this.getSelectors() == null) {
            return false;
        }
        if (other.getSelectors() != null && !other.getSelectors().equals(this.getSelectors())) {
            return false;
        }
        if (other.getStatistics() == null ^ this.getStatistics() == null) {
            return false;
        }
        return other.getStatistics() == null || other.getStatistics().equals(this.getStatistics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSelectors() == null ? 0 : this.getSelectors().hashCode());
        hashCode = 31 * hashCode + (this.getStatistics() == null ? 0 : this.getStatistics().hashCode());
        return hashCode;
    }

    public ColumnStatisticsConfiguration clone() {
        try {
            return (ColumnStatisticsConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ColumnStatisticsConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

