/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.UntagInstanceProfileRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UntagInstanceProfileRequestMarshaller
implements Marshaller<Request<UntagInstanceProfileRequest>, UntagInstanceProfileRequest> {
    public Request<UntagInstanceProfileRequest> marshall(UntagInstanceProfileRequest untagInstanceProfileRequest) {
        if (untagInstanceProfileRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)untagInstanceProfileRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "UntagInstanceProfile");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (untagInstanceProfileRequest.getInstanceProfileName() != null) {
            request.addParameter("InstanceProfileName", StringUtils.fromString((String)untagInstanceProfileRequest.getInstanceProfileName()));
        }
        if (!untagInstanceProfileRequest.getTagKeys().isEmpty() || !((SdkInternalList)untagInstanceProfileRequest.getTagKeys()).isAutoConstruct()) {
            SdkInternalList tagKeysList = (SdkInternalList)untagInstanceProfileRequest.getTagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.member." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        return request;
    }
}

