/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.transform.ThingGroupDocumentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThingGroupDocument
implements Serializable,
Cloneable,
StructuredPojo {
    private String thingGroupName;
    private String thingGroupId;
    private String thingGroupDescription;
    private Map<String, String> attributes;
    private List<String> parentGroupNames;

    public void setThingGroupName(String thingGroupName) {
        this.thingGroupName = thingGroupName;
    }

    public String getThingGroupName() {
        return this.thingGroupName;
    }

    public ThingGroupDocument withThingGroupName(String thingGroupName) {
        this.setThingGroupName(thingGroupName);
        return this;
    }

    public void setThingGroupId(String thingGroupId) {
        this.thingGroupId = thingGroupId;
    }

    public String getThingGroupId() {
        return this.thingGroupId;
    }

    public ThingGroupDocument withThingGroupId(String thingGroupId) {
        this.setThingGroupId(thingGroupId);
        return this;
    }

    public void setThingGroupDescription(String thingGroupDescription) {
        this.thingGroupDescription = thingGroupDescription;
    }

    public String getThingGroupDescription() {
        return this.thingGroupDescription;
    }

    public ThingGroupDocument withThingGroupDescription(String thingGroupDescription) {
        this.setThingGroupDescription(thingGroupDescription);
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ThingGroupDocument withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public ThingGroupDocument addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public ThingGroupDocument clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public List<String> getParentGroupNames() {
        return this.parentGroupNames;
    }

    public void setParentGroupNames(Collection<String> parentGroupNames) {
        if (parentGroupNames == null) {
            this.parentGroupNames = null;
            return;
        }
        this.parentGroupNames = new ArrayList<String>(parentGroupNames);
    }

    public ThingGroupDocument withParentGroupNames(String ... parentGroupNames) {
        if (this.parentGroupNames == null) {
            this.setParentGroupNames(new ArrayList<String>(parentGroupNames.length));
        }
        for (String ele : parentGroupNames) {
            this.parentGroupNames.add(ele);
        }
        return this;
    }

    public ThingGroupDocument withParentGroupNames(Collection<String> parentGroupNames) {
        this.setParentGroupNames(parentGroupNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getThingGroupName() != null) {
            sb.append("ThingGroupName: ").append(this.getThingGroupName()).append(",");
        }
        if (this.getThingGroupId() != null) {
            sb.append("ThingGroupId: ").append(this.getThingGroupId()).append(",");
        }
        if (this.getThingGroupDescription() != null) {
            sb.append("ThingGroupDescription: ").append(this.getThingGroupDescription()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getParentGroupNames() != null) {
            sb.append("ParentGroupNames: ").append(this.getParentGroupNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupDocument)) {
            return false;
        }
        ThingGroupDocument other = (ThingGroupDocument)obj;
        if (other.getThingGroupName() == null ^ this.getThingGroupName() == null) {
            return false;
        }
        if (other.getThingGroupName() != null && !other.getThingGroupName().equals(this.getThingGroupName())) {
            return false;
        }
        if (other.getThingGroupId() == null ^ this.getThingGroupId() == null) {
            return false;
        }
        if (other.getThingGroupId() != null && !other.getThingGroupId().equals(this.getThingGroupId())) {
            return false;
        }
        if (other.getThingGroupDescription() == null ^ this.getThingGroupDescription() == null) {
            return false;
        }
        if (other.getThingGroupDescription() != null && !other.getThingGroupDescription().equals(this.getThingGroupDescription())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getParentGroupNames() == null ^ this.getParentGroupNames() == null) {
            return false;
        }
        return other.getParentGroupNames() == null || other.getParentGroupNames().equals(this.getParentGroupNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getThingGroupName() == null ? 0 : this.getThingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getThingGroupId() == null ? 0 : this.getThingGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getThingGroupDescription() == null ? 0 : this.getThingGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getParentGroupNames() == null ? 0 : this.getParentGroupNames().hashCode());
        return hashCode;
    }

    public ThingGroupDocument clone() {
        try {
            return (ThingGroupDocument)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingGroupDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

