/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RunPipelineActivityResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ByteBuffer> payloads;
    private String logResult;

    public List<ByteBuffer> getPayloads() {
        return this.payloads;
    }

    public void setPayloads(Collection<ByteBuffer> payloads) {
        if (payloads == null) {
            this.payloads = null;
            return;
        }
        this.payloads = new ArrayList<ByteBuffer>(payloads);
    }

    public RunPipelineActivityResult withPayloads(ByteBuffer ... payloads) {
        if (this.payloads == null) {
            this.setPayloads(new ArrayList<ByteBuffer>(payloads.length));
        }
        for (ByteBuffer ele : payloads) {
            this.payloads.add(ele);
        }
        return this;
    }

    public RunPipelineActivityResult withPayloads(Collection<ByteBuffer> payloads) {
        this.setPayloads(payloads);
        return this;
    }

    public void setLogResult(String logResult) {
        this.logResult = logResult;
    }

    public String getLogResult() {
        return this.logResult;
    }

    public RunPipelineActivityResult withLogResult(String logResult) {
        this.setLogResult(logResult);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPayloads() != null) {
            sb.append("Payloads: ").append(this.getPayloads()).append(",");
        }
        if (this.getLogResult() != null) {
            sb.append("LogResult: ").append(this.getLogResult());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunPipelineActivityResult)) {
            return false;
        }
        RunPipelineActivityResult other = (RunPipelineActivityResult)obj;
        if (other.getPayloads() == null ^ this.getPayloads() == null) {
            return false;
        }
        if (other.getPayloads() != null && !other.getPayloads().equals(this.getPayloads())) {
            return false;
        }
        if (other.getLogResult() == null ^ this.getLogResult() == null) {
            return false;
        }
        return other.getLogResult() == null || other.getLogResult().equals(this.getLogResult());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPayloads() == null ? 0 : this.getPayloads().hashCode());
        hashCode = 31 * hashCode + (this.getLogResult() == null ? 0 : this.getLogResult().hashCode());
        return hashCode;
    }

    public RunPipelineActivityResult clone() {
        try {
            return (RunPipelineActivityResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

