/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.Disk;
import java.util.Date;

@SdkInternalApi
public class DiskMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<Integer> SIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sizeInGb").build();
    private static final MarshallingInfo<Integer> GBINUSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gbInUse").build();
    private static final MarshallingInfo<Boolean> ISSYSTEMDISK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isSystemDisk").build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iops").build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("path").build();
    private static final MarshallingInfo<String> ATTACHEDTO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachedTo").build();
    private static final MarshallingInfo<Boolean> ISATTACHED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isAttached").build();
    private static final MarshallingInfo<String> ATTACHMENTSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachmentState").build();
    private static final DiskMarshaller instance = new DiskMarshaller();

    public static DiskMarshaller getInstance() {
        return instance;
    }

    public void marshall(Disk disk, ProtocolMarshaller protocolMarshaller) {
        if (disk == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)disk.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)disk.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)disk.getSupportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall((Object)disk.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)disk.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)disk.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)disk.getSizeInGb(), SIZEINGB_BINDING);
            protocolMarshaller.marshall((Object)disk.getGbInUse(), GBINUSE_BINDING);
            protocolMarshaller.marshall((Object)disk.getIsSystemDisk(), ISSYSTEMDISK_BINDING);
            protocolMarshaller.marshall((Object)disk.getIops(), IOPS_BINDING);
            protocolMarshaller.marshall((Object)disk.getPath(), PATH_BINDING);
            protocolMarshaller.marshall((Object)disk.getAttachedTo(), ATTACHEDTO_BINDING);
            protocolMarshaller.marshall((Object)disk.getIsAttached(), ISATTACHED_BINDING);
            protocolMarshaller.marshall((Object)disk.getAttachmentState(), ATTACHMENTSTATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

