/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.nimblestudio.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.nimblestudio.model.AutomaticTerminationMode;
import com.amazonaws.services.nimblestudio.model.SessionPersistenceMode;
import com.amazonaws.services.nimblestudio.model.StreamConfigurationSessionBackup;
import com.amazonaws.services.nimblestudio.model.StreamConfigurationSessionStorage;
import com.amazonaws.services.nimblestudio.model.StreamingClipboardMode;
import com.amazonaws.services.nimblestudio.model.StreamingInstanceType;
import com.amazonaws.services.nimblestudio.model.VolumeConfiguration;
import com.amazonaws.services.nimblestudio.model.transform.StreamConfigurationCreateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StreamConfigurationCreate
implements Serializable,
Cloneable,
StructuredPojo {
    private String automaticTerminationMode;
    private String clipboardMode;
    private List<String> ec2InstanceTypes;
    private Integer maxSessionLengthInMinutes;
    private Integer maxStoppedSessionLengthInMinutes;
    private StreamConfigurationSessionBackup sessionBackup;
    private String sessionPersistenceMode;
    private StreamConfigurationSessionStorage sessionStorage;
    private List<String> streamingImageIds;
    private VolumeConfiguration volumeConfiguration;

    public void setAutomaticTerminationMode(String automaticTerminationMode) {
        this.automaticTerminationMode = automaticTerminationMode;
    }

    public String getAutomaticTerminationMode() {
        return this.automaticTerminationMode;
    }

    public StreamConfigurationCreate withAutomaticTerminationMode(String automaticTerminationMode) {
        this.setAutomaticTerminationMode(automaticTerminationMode);
        return this;
    }

    public StreamConfigurationCreate withAutomaticTerminationMode(AutomaticTerminationMode automaticTerminationMode) {
        this.automaticTerminationMode = automaticTerminationMode.toString();
        return this;
    }

    public void setClipboardMode(String clipboardMode) {
        this.clipboardMode = clipboardMode;
    }

    public String getClipboardMode() {
        return this.clipboardMode;
    }

    public StreamConfigurationCreate withClipboardMode(String clipboardMode) {
        this.setClipboardMode(clipboardMode);
        return this;
    }

    public StreamConfigurationCreate withClipboardMode(StreamingClipboardMode clipboardMode) {
        this.clipboardMode = clipboardMode.toString();
        return this;
    }

    public List<String> getEc2InstanceTypes() {
        return this.ec2InstanceTypes;
    }

    public void setEc2InstanceTypes(Collection<String> ec2InstanceTypes) {
        if (ec2InstanceTypes == null) {
            this.ec2InstanceTypes = null;
            return;
        }
        this.ec2InstanceTypes = new ArrayList<String>(ec2InstanceTypes);
    }

    public StreamConfigurationCreate withEc2InstanceTypes(String ... ec2InstanceTypes) {
        if (this.ec2InstanceTypes == null) {
            this.setEc2InstanceTypes(new ArrayList<String>(ec2InstanceTypes.length));
        }
        for (String ele : ec2InstanceTypes) {
            this.ec2InstanceTypes.add(ele);
        }
        return this;
    }

    public StreamConfigurationCreate withEc2InstanceTypes(Collection<String> ec2InstanceTypes) {
        this.setEc2InstanceTypes(ec2InstanceTypes);
        return this;
    }

    public StreamConfigurationCreate withEc2InstanceTypes(StreamingInstanceType ... ec2InstanceTypes) {
        ArrayList<String> ec2InstanceTypesCopy = new ArrayList<String>(ec2InstanceTypes.length);
        for (StreamingInstanceType value : ec2InstanceTypes) {
            ec2InstanceTypesCopy.add(value.toString());
        }
        if (this.getEc2InstanceTypes() == null) {
            this.setEc2InstanceTypes(ec2InstanceTypesCopy);
        } else {
            this.getEc2InstanceTypes().addAll(ec2InstanceTypesCopy);
        }
        return this;
    }

    public void setMaxSessionLengthInMinutes(Integer maxSessionLengthInMinutes) {
        this.maxSessionLengthInMinutes = maxSessionLengthInMinutes;
    }

    public Integer getMaxSessionLengthInMinutes() {
        return this.maxSessionLengthInMinutes;
    }

    public StreamConfigurationCreate withMaxSessionLengthInMinutes(Integer maxSessionLengthInMinutes) {
        this.setMaxSessionLengthInMinutes(maxSessionLengthInMinutes);
        return this;
    }

    public void setMaxStoppedSessionLengthInMinutes(Integer maxStoppedSessionLengthInMinutes) {
        this.maxStoppedSessionLengthInMinutes = maxStoppedSessionLengthInMinutes;
    }

    public Integer getMaxStoppedSessionLengthInMinutes() {
        return this.maxStoppedSessionLengthInMinutes;
    }

    public StreamConfigurationCreate withMaxStoppedSessionLengthInMinutes(Integer maxStoppedSessionLengthInMinutes) {
        this.setMaxStoppedSessionLengthInMinutes(maxStoppedSessionLengthInMinutes);
        return this;
    }

    public void setSessionBackup(StreamConfigurationSessionBackup sessionBackup) {
        this.sessionBackup = sessionBackup;
    }

    public StreamConfigurationSessionBackup getSessionBackup() {
        return this.sessionBackup;
    }

    public StreamConfigurationCreate withSessionBackup(StreamConfigurationSessionBackup sessionBackup) {
        this.setSessionBackup(sessionBackup);
        return this;
    }

    public void setSessionPersistenceMode(String sessionPersistenceMode) {
        this.sessionPersistenceMode = sessionPersistenceMode;
    }

    public String getSessionPersistenceMode() {
        return this.sessionPersistenceMode;
    }

    public StreamConfigurationCreate withSessionPersistenceMode(String sessionPersistenceMode) {
        this.setSessionPersistenceMode(sessionPersistenceMode);
        return this;
    }

    public StreamConfigurationCreate withSessionPersistenceMode(SessionPersistenceMode sessionPersistenceMode) {
        this.sessionPersistenceMode = sessionPersistenceMode.toString();
        return this;
    }

    public void setSessionStorage(StreamConfigurationSessionStorage sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    public StreamConfigurationSessionStorage getSessionStorage() {
        return this.sessionStorage;
    }

    public StreamConfigurationCreate withSessionStorage(StreamConfigurationSessionStorage sessionStorage) {
        this.setSessionStorage(sessionStorage);
        return this;
    }

    public List<String> getStreamingImageIds() {
        return this.streamingImageIds;
    }

    public void setStreamingImageIds(Collection<String> streamingImageIds) {
        if (streamingImageIds == null) {
            this.streamingImageIds = null;
            return;
        }
        this.streamingImageIds = new ArrayList<String>(streamingImageIds);
    }

    public StreamConfigurationCreate withStreamingImageIds(String ... streamingImageIds) {
        if (this.streamingImageIds == null) {
            this.setStreamingImageIds(new ArrayList<String>(streamingImageIds.length));
        }
        for (String ele : streamingImageIds) {
            this.streamingImageIds.add(ele);
        }
        return this;
    }

    public StreamConfigurationCreate withStreamingImageIds(Collection<String> streamingImageIds) {
        this.setStreamingImageIds(streamingImageIds);
        return this;
    }

    public void setVolumeConfiguration(VolumeConfiguration volumeConfiguration) {
        this.volumeConfiguration = volumeConfiguration;
    }

    public VolumeConfiguration getVolumeConfiguration() {
        return this.volumeConfiguration;
    }

    public StreamConfigurationCreate withVolumeConfiguration(VolumeConfiguration volumeConfiguration) {
        this.setVolumeConfiguration(volumeConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutomaticTerminationMode() != null) {
            sb.append("AutomaticTerminationMode: ").append(this.getAutomaticTerminationMode()).append(",");
        }
        if (this.getClipboardMode() != null) {
            sb.append("ClipboardMode: ").append(this.getClipboardMode()).append(",");
        }
        if (this.getEc2InstanceTypes() != null) {
            sb.append("Ec2InstanceTypes: ").append(this.getEc2InstanceTypes()).append(",");
        }
        if (this.getMaxSessionLengthInMinutes() != null) {
            sb.append("MaxSessionLengthInMinutes: ").append(this.getMaxSessionLengthInMinutes()).append(",");
        }
        if (this.getMaxStoppedSessionLengthInMinutes() != null) {
            sb.append("MaxStoppedSessionLengthInMinutes: ").append(this.getMaxStoppedSessionLengthInMinutes()).append(",");
        }
        if (this.getSessionBackup() != null) {
            sb.append("SessionBackup: ").append(this.getSessionBackup()).append(",");
        }
        if (this.getSessionPersistenceMode() != null) {
            sb.append("SessionPersistenceMode: ").append(this.getSessionPersistenceMode()).append(",");
        }
        if (this.getSessionStorage() != null) {
            sb.append("SessionStorage: ").append(this.getSessionStorage()).append(",");
        }
        if (this.getStreamingImageIds() != null) {
            sb.append("StreamingImageIds: ").append(this.getStreamingImageIds()).append(",");
        }
        if (this.getVolumeConfiguration() != null) {
            sb.append("VolumeConfiguration: ").append(this.getVolumeConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamConfigurationCreate)) {
            return false;
        }
        StreamConfigurationCreate other = (StreamConfigurationCreate)obj;
        if (other.getAutomaticTerminationMode() == null ^ this.getAutomaticTerminationMode() == null) {
            return false;
        }
        if (other.getAutomaticTerminationMode() != null && !other.getAutomaticTerminationMode().equals(this.getAutomaticTerminationMode())) {
            return false;
        }
        if (other.getClipboardMode() == null ^ this.getClipboardMode() == null) {
            return false;
        }
        if (other.getClipboardMode() != null && !other.getClipboardMode().equals(this.getClipboardMode())) {
            return false;
        }
        if (other.getEc2InstanceTypes() == null ^ this.getEc2InstanceTypes() == null) {
            return false;
        }
        if (other.getEc2InstanceTypes() != null && !other.getEc2InstanceTypes().equals(this.getEc2InstanceTypes())) {
            return false;
        }
        if (other.getMaxSessionLengthInMinutes() == null ^ this.getMaxSessionLengthInMinutes() == null) {
            return false;
        }
        if (other.getMaxSessionLengthInMinutes() != null && !other.getMaxSessionLengthInMinutes().equals(this.getMaxSessionLengthInMinutes())) {
            return false;
        }
        if (other.getMaxStoppedSessionLengthInMinutes() == null ^ this.getMaxStoppedSessionLengthInMinutes() == null) {
            return false;
        }
        if (other.getMaxStoppedSessionLengthInMinutes() != null && !other.getMaxStoppedSessionLengthInMinutes().equals(this.getMaxStoppedSessionLengthInMinutes())) {
            return false;
        }
        if (other.getSessionBackup() == null ^ this.getSessionBackup() == null) {
            return false;
        }
        if (other.getSessionBackup() != null && !other.getSessionBackup().equals(this.getSessionBackup())) {
            return false;
        }
        if (other.getSessionPersistenceMode() == null ^ this.getSessionPersistenceMode() == null) {
            return false;
        }
        if (other.getSessionPersistenceMode() != null && !other.getSessionPersistenceMode().equals(this.getSessionPersistenceMode())) {
            return false;
        }
        if (other.getSessionStorage() == null ^ this.getSessionStorage() == null) {
            return false;
        }
        if (other.getSessionStorage() != null && !other.getSessionStorage().equals(this.getSessionStorage())) {
            return false;
        }
        if (other.getStreamingImageIds() == null ^ this.getStreamingImageIds() == null) {
            return false;
        }
        if (other.getStreamingImageIds() != null && !other.getStreamingImageIds().equals(this.getStreamingImageIds())) {
            return false;
        }
        if (other.getVolumeConfiguration() == null ^ this.getVolumeConfiguration() == null) {
            return false;
        }
        return other.getVolumeConfiguration() == null || other.getVolumeConfiguration().equals(this.getVolumeConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutomaticTerminationMode() == null ? 0 : this.getAutomaticTerminationMode().hashCode());
        hashCode = 31 * hashCode + (this.getClipboardMode() == null ? 0 : this.getClipboardMode().hashCode());
        hashCode = 31 * hashCode + (this.getEc2InstanceTypes() == null ? 0 : this.getEc2InstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSessionLengthInMinutes() == null ? 0 : this.getMaxSessionLengthInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getMaxStoppedSessionLengthInMinutes() == null ? 0 : this.getMaxStoppedSessionLengthInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getSessionBackup() == null ? 0 : this.getSessionBackup().hashCode());
        hashCode = 31 * hashCode + (this.getSessionPersistenceMode() == null ? 0 : this.getSessionPersistenceMode().hashCode());
        hashCode = 31 * hashCode + (this.getSessionStorage() == null ? 0 : this.getSessionStorage().hashCode());
        hashCode = 31 * hashCode + (this.getStreamingImageIds() == null ? 0 : this.getStreamingImageIds().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeConfiguration() == null ? 0 : this.getVolumeConfiguration().hashCode());
        return hashCode;
    }

    public StreamConfigurationCreate clone() {
        try {
            return (StreamConfigurationCreate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamConfigurationCreateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

