/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.DescribeEcsClustersRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeEcsClustersRequestMarshaller
implements Marshaller<Request<DescribeEcsClustersRequest>, DescribeEcsClustersRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeEcsClustersRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeEcsClustersRequest> marshall(DescribeEcsClustersRequest describeEcsClustersRequest) {
        if (describeEcsClustersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEcsClustersRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeEcsClusters");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList ecsClusterArnsList = (SdkInternalList)describeEcsClustersRequest.getEcsClusterArns();
            if (!ecsClusterArnsList.isEmpty() || !ecsClusterArnsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("EcsClusterArns");
                jsonGenerator.writeStartArray();
                for (String ecsClusterArnsListValue : ecsClusterArnsList) {
                    if (ecsClusterArnsListValue == null) continue;
                    jsonGenerator.writeValue(ecsClusterArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeEcsClustersRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(describeEcsClustersRequest.getStackId());
            }
            if (describeEcsClustersRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeEcsClustersRequest.getNextToken());
            }
            if (describeEcsClustersRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(describeEcsClustersRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

