/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointsmsvoicev2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.pinpointsmsvoicev2.model.CloudWatchLogsDestination;
import com.amazonaws.services.pinpointsmsvoicev2.model.EventType;
import com.amazonaws.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination;
import com.amazonaws.services.pinpointsmsvoicev2.model.SnsDestination;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateEventDestinationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String configurationSetName;
    private String eventDestinationName;
    private List<String> matchingEventTypes;
    private CloudWatchLogsDestination cloudWatchLogsDestination;
    private KinesisFirehoseDestination kinesisFirehoseDestination;
    private SnsDestination snsDestination;
    private String clientToken;

    public void setConfigurationSetName(String configurationSetName) {
        this.configurationSetName = configurationSetName;
    }

    public String getConfigurationSetName() {
        return this.configurationSetName;
    }

    public CreateEventDestinationRequest withConfigurationSetName(String configurationSetName) {
        this.setConfigurationSetName(configurationSetName);
        return this;
    }

    public void setEventDestinationName(String eventDestinationName) {
        this.eventDestinationName = eventDestinationName;
    }

    public String getEventDestinationName() {
        return this.eventDestinationName;
    }

    public CreateEventDestinationRequest withEventDestinationName(String eventDestinationName) {
        this.setEventDestinationName(eventDestinationName);
        return this;
    }

    public List<String> getMatchingEventTypes() {
        return this.matchingEventTypes;
    }

    public void setMatchingEventTypes(Collection<String> matchingEventTypes) {
        if (matchingEventTypes == null) {
            this.matchingEventTypes = null;
            return;
        }
        this.matchingEventTypes = new ArrayList<String>(matchingEventTypes);
    }

    public CreateEventDestinationRequest withMatchingEventTypes(String ... matchingEventTypes) {
        if (this.matchingEventTypes == null) {
            this.setMatchingEventTypes(new ArrayList<String>(matchingEventTypes.length));
        }
        for (String ele : matchingEventTypes) {
            this.matchingEventTypes.add(ele);
        }
        return this;
    }

    public CreateEventDestinationRequest withMatchingEventTypes(Collection<String> matchingEventTypes) {
        this.setMatchingEventTypes(matchingEventTypes);
        return this;
    }

    public CreateEventDestinationRequest withMatchingEventTypes(EventType ... matchingEventTypes) {
        ArrayList<String> matchingEventTypesCopy = new ArrayList<String>(matchingEventTypes.length);
        for (EventType value : matchingEventTypes) {
            matchingEventTypesCopy.add(value.toString());
        }
        if (this.getMatchingEventTypes() == null) {
            this.setMatchingEventTypes(matchingEventTypesCopy);
        } else {
            this.getMatchingEventTypes().addAll(matchingEventTypesCopy);
        }
        return this;
    }

    public void setCloudWatchLogsDestination(CloudWatchLogsDestination cloudWatchLogsDestination) {
        this.cloudWatchLogsDestination = cloudWatchLogsDestination;
    }

    public CloudWatchLogsDestination getCloudWatchLogsDestination() {
        return this.cloudWatchLogsDestination;
    }

    public CreateEventDestinationRequest withCloudWatchLogsDestination(CloudWatchLogsDestination cloudWatchLogsDestination) {
        this.setCloudWatchLogsDestination(cloudWatchLogsDestination);
        return this;
    }

    public void setKinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
        this.kinesisFirehoseDestination = kinesisFirehoseDestination;
    }

    public KinesisFirehoseDestination getKinesisFirehoseDestination() {
        return this.kinesisFirehoseDestination;
    }

    public CreateEventDestinationRequest withKinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
        this.setKinesisFirehoseDestination(kinesisFirehoseDestination);
        return this;
    }

    public void setSnsDestination(SnsDestination snsDestination) {
        this.snsDestination = snsDestination;
    }

    public SnsDestination getSnsDestination() {
        return this.snsDestination;
    }

    public CreateEventDestinationRequest withSnsDestination(SnsDestination snsDestination) {
        this.setSnsDestination(snsDestination);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateEventDestinationRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfigurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(this.getConfigurationSetName()).append(",");
        }
        if (this.getEventDestinationName() != null) {
            sb.append("EventDestinationName: ").append(this.getEventDestinationName()).append(",");
        }
        if (this.getMatchingEventTypes() != null) {
            sb.append("MatchingEventTypes: ").append(this.getMatchingEventTypes()).append(",");
        }
        if (this.getCloudWatchLogsDestination() != null) {
            sb.append("CloudWatchLogsDestination: ").append(this.getCloudWatchLogsDestination()).append(",");
        }
        if (this.getKinesisFirehoseDestination() != null) {
            sb.append("KinesisFirehoseDestination: ").append(this.getKinesisFirehoseDestination()).append(",");
        }
        if (this.getSnsDestination() != null) {
            sb.append("SnsDestination: ").append(this.getSnsDestination()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventDestinationRequest)) {
            return false;
        }
        CreateEventDestinationRequest other = (CreateEventDestinationRequest)obj;
        if (other.getConfigurationSetName() == null ^ this.getConfigurationSetName() == null) {
            return false;
        }
        if (other.getConfigurationSetName() != null && !other.getConfigurationSetName().equals(this.getConfigurationSetName())) {
            return false;
        }
        if (other.getEventDestinationName() == null ^ this.getEventDestinationName() == null) {
            return false;
        }
        if (other.getEventDestinationName() != null && !other.getEventDestinationName().equals(this.getEventDestinationName())) {
            return false;
        }
        if (other.getMatchingEventTypes() == null ^ this.getMatchingEventTypes() == null) {
            return false;
        }
        if (other.getMatchingEventTypes() != null && !other.getMatchingEventTypes().equals(this.getMatchingEventTypes())) {
            return false;
        }
        if (other.getCloudWatchLogsDestination() == null ^ this.getCloudWatchLogsDestination() == null) {
            return false;
        }
        if (other.getCloudWatchLogsDestination() != null && !other.getCloudWatchLogsDestination().equals(this.getCloudWatchLogsDestination())) {
            return false;
        }
        if (other.getKinesisFirehoseDestination() == null ^ this.getKinesisFirehoseDestination() == null) {
            return false;
        }
        if (other.getKinesisFirehoseDestination() != null && !other.getKinesisFirehoseDestination().equals(this.getKinesisFirehoseDestination())) {
            return false;
        }
        if (other.getSnsDestination() == null ^ this.getSnsDestination() == null) {
            return false;
        }
        if (other.getSnsDestination() != null && !other.getSnsDestination().equals(this.getSnsDestination())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfigurationSetName() == null ? 0 : this.getConfigurationSetName().hashCode());
        hashCode = 31 * hashCode + (this.getEventDestinationName() == null ? 0 : this.getEventDestinationName().hashCode());
        hashCode = 31 * hashCode + (this.getMatchingEventTypes() == null ? 0 : this.getMatchingEventTypes().hashCode());
        hashCode = 31 * hashCode + (this.getCloudWatchLogsDestination() == null ? 0 : this.getCloudWatchLogsDestination().hashCode());
        hashCode = 31 * hashCode + (this.getKinesisFirehoseDestination() == null ? 0 : this.getKinesisFirehoseDestination().hashCode());
        hashCode = 31 * hashCode + (this.getSnsDestination() == null ? 0 : this.getSnsDestination().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreateEventDestinationRequest clone() {
        return (CreateEventDestinationRequest)super.clone();
    }
}

