/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.DoubleRange;
import com.amazonaws.services.rds.model.Range;
import com.amazonaws.services.rds.model.ValidStorageOptions;
import com.amazonaws.services.rds.model.transform.DoubleRangeStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.RangeStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ValidStorageOptionsStaxUnmarshaller
implements Unmarshaller<ValidStorageOptions, StaxUnmarshallerContext> {
    private static ValidStorageOptionsStaxUnmarshaller instance;

    public ValidStorageOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        ValidStorageOptions validStorageOptions = new ValidStorageOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return validStorageOptions;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StorageType", targetDepth)) {
                    validStorageOptions.setStorageType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StorageSize", targetDepth)) {
                    validStorageOptions.withStorageSize(new ArrayList<Range>());
                    continue;
                }
                if (context.testExpression("StorageSize/Range", targetDepth)) {
                    validStorageOptions.withStorageSize(RangeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProvisionedIops", targetDepth)) {
                    validStorageOptions.withProvisionedIops(new ArrayList<Range>());
                    continue;
                }
                if (context.testExpression("ProvisionedIops/Range", targetDepth)) {
                    validStorageOptions.withProvisionedIops(RangeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IopsToStorageRatio", targetDepth)) {
                    validStorageOptions.withIopsToStorageRatio(new ArrayList<DoubleRange>());
                    continue;
                }
                if (context.testExpression("IopsToStorageRatio/DoubleRange", targetDepth)) {
                    validStorageOptions.withIopsToStorageRatio(DoubleRangeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportsStorageAutoscaling", targetDepth)) {
                    validStorageOptions.setSupportsStorageAutoscaling(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProvisionedStorageThroughput", targetDepth)) {
                    validStorageOptions.withProvisionedStorageThroughput(new ArrayList<Range>());
                    continue;
                }
                if (context.testExpression("ProvisionedStorageThroughput/Range", targetDepth)) {
                    validStorageOptions.withProvisionedStorageThroughput(RangeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StorageThroughputToIopsRatio", targetDepth)) {
                    validStorageOptions.withStorageThroughputToIopsRatio(new ArrayList<DoubleRange>());
                    continue;
                }
                if (!context.testExpression("StorageThroughputToIopsRatio/DoubleRange", targetDepth)) continue;
                validStorageOptions.withStorageThroughputToIopsRatio(DoubleRangeStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return validStorageOptions;
    }

    public static ValidStorageOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ValidStorageOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

