/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.DeleteBucketRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class DeleteBucketRequestMarshaller
implements Marshaller<Request<DeleteBucketRequest>, DeleteBucketRequest> {
    public Request<DeleteBucketRequest> marshall(DeleteBucketRequest deleteBucketRequest) {
        if (deleteBucketRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteBucketRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteBucketRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)deleteBucketRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", deleteBucketRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

