/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.GetBucketReplicationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class GetBucketReplicationRequestMarshaller
implements Marshaller<Request<GetBucketReplicationRequest>, GetBucketReplicationRequest> {
    public Request<GetBucketReplicationRequest> marshall(GetBucketReplicationRequest getBucketReplicationRequest) {
        if (getBucketReplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getBucketReplicationRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (getBucketReplicationRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)getBucketReplicationRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}/replication";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", getBucketReplicationRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

