/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.LifecycleConfiguration;
import com.amazonaws.services.s3control.model.LifecycleRule;
import com.amazonaws.services.s3control.model.transform.LifecycleRuleStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class LifecycleConfigurationStaxUnmarshaller
implements Unmarshaller<LifecycleConfiguration, StaxUnmarshallerContext> {
    private static LifecycleConfigurationStaxUnmarshaller instance;

    public LifecycleConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        LifecycleConfiguration lifecycleConfiguration = new LifecycleConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return lifecycleConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Rules", targetDepth)) {
                    lifecycleConfiguration.withRules(new ArrayList<LifecycleRule>());
                    continue;
                }
                if (!context.testExpression("Rules/Rule", targetDepth)) continue;
                lifecycleConfiguration.withRules(LifecycleRuleStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return lifecycleConfiguration;
    }

    public static LifecycleConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LifecycleConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

