/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.NoncurrentVersionTransition;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class NoncurrentVersionTransitionStaxUnmarshaller
implements Unmarshaller<NoncurrentVersionTransition, StaxUnmarshallerContext> {
    private static NoncurrentVersionTransitionStaxUnmarshaller instance;

    public NoncurrentVersionTransition unmarshall(StaxUnmarshallerContext context) throws Exception {
        NoncurrentVersionTransition noncurrentVersionTransition = new NoncurrentVersionTransition();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return noncurrentVersionTransition;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NoncurrentDays", targetDepth)) {
                    noncurrentVersionTransition.setNoncurrentDays(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("StorageClass", targetDepth)) continue;
                noncurrentVersionTransition.setStorageClass(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return noncurrentVersionTransition;
    }

    public static NoncurrentVersionTransitionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NoncurrentVersionTransitionStaxUnmarshaller();
        }
        return instance;
    }
}

