/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.Cvss;
import com.amazonaws.services.securityhub.model.SoftwarePackage;
import com.amazonaws.services.securityhub.model.VulnerabilityCodeVulnerabilities;
import com.amazonaws.services.securityhub.model.VulnerabilityExploitAvailable;
import com.amazonaws.services.securityhub.model.VulnerabilityFixAvailable;
import com.amazonaws.services.securityhub.model.VulnerabilityVendor;
import com.amazonaws.services.securityhub.model.transform.VulnerabilityMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Vulnerability
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private List<SoftwarePackage> vulnerablePackages;
    private List<Cvss> cvss;
    private List<String> relatedVulnerabilities;
    private VulnerabilityVendor vendor;
    private List<String> referenceUrls;
    private String fixAvailable;
    private Double epssScore;
    private String exploitAvailable;
    private List<VulnerabilityCodeVulnerabilities> codeVulnerabilities;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Vulnerability withId(String id) {
        this.setId(id);
        return this;
    }

    public List<SoftwarePackage> getVulnerablePackages() {
        return this.vulnerablePackages;
    }

    public void setVulnerablePackages(Collection<SoftwarePackage> vulnerablePackages) {
        if (vulnerablePackages == null) {
            this.vulnerablePackages = null;
            return;
        }
        this.vulnerablePackages = new ArrayList<SoftwarePackage>(vulnerablePackages);
    }

    public Vulnerability withVulnerablePackages(SoftwarePackage ... vulnerablePackages) {
        if (this.vulnerablePackages == null) {
            this.setVulnerablePackages(new ArrayList<SoftwarePackage>(vulnerablePackages.length));
        }
        for (SoftwarePackage ele : vulnerablePackages) {
            this.vulnerablePackages.add(ele);
        }
        return this;
    }

    public Vulnerability withVulnerablePackages(Collection<SoftwarePackage> vulnerablePackages) {
        this.setVulnerablePackages(vulnerablePackages);
        return this;
    }

    public List<Cvss> getCvss() {
        return this.cvss;
    }

    public void setCvss(Collection<Cvss> cvss) {
        if (cvss == null) {
            this.cvss = null;
            return;
        }
        this.cvss = new ArrayList<Cvss>(cvss);
    }

    public Vulnerability withCvss(Cvss ... cvss) {
        if (this.cvss == null) {
            this.setCvss(new ArrayList<Cvss>(cvss.length));
        }
        for (Cvss ele : cvss) {
            this.cvss.add(ele);
        }
        return this;
    }

    public Vulnerability withCvss(Collection<Cvss> cvss) {
        this.setCvss(cvss);
        return this;
    }

    public List<String> getRelatedVulnerabilities() {
        return this.relatedVulnerabilities;
    }

    public void setRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
        if (relatedVulnerabilities == null) {
            this.relatedVulnerabilities = null;
            return;
        }
        this.relatedVulnerabilities = new ArrayList<String>(relatedVulnerabilities);
    }

    public Vulnerability withRelatedVulnerabilities(String ... relatedVulnerabilities) {
        if (this.relatedVulnerabilities == null) {
            this.setRelatedVulnerabilities(new ArrayList<String>(relatedVulnerabilities.length));
        }
        for (String ele : relatedVulnerabilities) {
            this.relatedVulnerabilities.add(ele);
        }
        return this;
    }

    public Vulnerability withRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
        this.setRelatedVulnerabilities(relatedVulnerabilities);
        return this;
    }

    public void setVendor(VulnerabilityVendor vendor) {
        this.vendor = vendor;
    }

    public VulnerabilityVendor getVendor() {
        return this.vendor;
    }

    public Vulnerability withVendor(VulnerabilityVendor vendor) {
        this.setVendor(vendor);
        return this;
    }

    public List<String> getReferenceUrls() {
        return this.referenceUrls;
    }

    public void setReferenceUrls(Collection<String> referenceUrls) {
        if (referenceUrls == null) {
            this.referenceUrls = null;
            return;
        }
        this.referenceUrls = new ArrayList<String>(referenceUrls);
    }

    public Vulnerability withReferenceUrls(String ... referenceUrls) {
        if (this.referenceUrls == null) {
            this.setReferenceUrls(new ArrayList<String>(referenceUrls.length));
        }
        for (String ele : referenceUrls) {
            this.referenceUrls.add(ele);
        }
        return this;
    }

    public Vulnerability withReferenceUrls(Collection<String> referenceUrls) {
        this.setReferenceUrls(referenceUrls);
        return this;
    }

    public void setFixAvailable(String fixAvailable) {
        this.fixAvailable = fixAvailable;
    }

    public String getFixAvailable() {
        return this.fixAvailable;
    }

    public Vulnerability withFixAvailable(String fixAvailable) {
        this.setFixAvailable(fixAvailable);
        return this;
    }

    public Vulnerability withFixAvailable(VulnerabilityFixAvailable fixAvailable) {
        this.fixAvailable = fixAvailable.toString();
        return this;
    }

    public void setEpssScore(Double epssScore) {
        this.epssScore = epssScore;
    }

    public Double getEpssScore() {
        return this.epssScore;
    }

    public Vulnerability withEpssScore(Double epssScore) {
        this.setEpssScore(epssScore);
        return this;
    }

    public void setExploitAvailable(String exploitAvailable) {
        this.exploitAvailable = exploitAvailable;
    }

    public String getExploitAvailable() {
        return this.exploitAvailable;
    }

    public Vulnerability withExploitAvailable(String exploitAvailable) {
        this.setExploitAvailable(exploitAvailable);
        return this;
    }

    public Vulnerability withExploitAvailable(VulnerabilityExploitAvailable exploitAvailable) {
        this.exploitAvailable = exploitAvailable.toString();
        return this;
    }

    public List<VulnerabilityCodeVulnerabilities> getCodeVulnerabilities() {
        return this.codeVulnerabilities;
    }

    public void setCodeVulnerabilities(Collection<VulnerabilityCodeVulnerabilities> codeVulnerabilities) {
        if (codeVulnerabilities == null) {
            this.codeVulnerabilities = null;
            return;
        }
        this.codeVulnerabilities = new ArrayList<VulnerabilityCodeVulnerabilities>(codeVulnerabilities);
    }

    public Vulnerability withCodeVulnerabilities(VulnerabilityCodeVulnerabilities ... codeVulnerabilities) {
        if (this.codeVulnerabilities == null) {
            this.setCodeVulnerabilities(new ArrayList<VulnerabilityCodeVulnerabilities>(codeVulnerabilities.length));
        }
        for (VulnerabilityCodeVulnerabilities ele : codeVulnerabilities) {
            this.codeVulnerabilities.add(ele);
        }
        return this;
    }

    public Vulnerability withCodeVulnerabilities(Collection<VulnerabilityCodeVulnerabilities> codeVulnerabilities) {
        this.setCodeVulnerabilities(codeVulnerabilities);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getVulnerablePackages() != null) {
            sb.append("VulnerablePackages: ").append(this.getVulnerablePackages()).append(",");
        }
        if (this.getCvss() != null) {
            sb.append("Cvss: ").append(this.getCvss()).append(",");
        }
        if (this.getRelatedVulnerabilities() != null) {
            sb.append("RelatedVulnerabilities: ").append(this.getRelatedVulnerabilities()).append(",");
        }
        if (this.getVendor() != null) {
            sb.append("Vendor: ").append(this.getVendor()).append(",");
        }
        if (this.getReferenceUrls() != null) {
            sb.append("ReferenceUrls: ").append(this.getReferenceUrls()).append(",");
        }
        if (this.getFixAvailable() != null) {
            sb.append("FixAvailable: ").append(this.getFixAvailable()).append(",");
        }
        if (this.getEpssScore() != null) {
            sb.append("EpssScore: ").append(this.getEpssScore()).append(",");
        }
        if (this.getExploitAvailable() != null) {
            sb.append("ExploitAvailable: ").append(this.getExploitAvailable()).append(",");
        }
        if (this.getCodeVulnerabilities() != null) {
            sb.append("CodeVulnerabilities: ").append(this.getCodeVulnerabilities());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vulnerability)) {
            return false;
        }
        Vulnerability other = (Vulnerability)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getVulnerablePackages() == null ^ this.getVulnerablePackages() == null) {
            return false;
        }
        if (other.getVulnerablePackages() != null && !other.getVulnerablePackages().equals(this.getVulnerablePackages())) {
            return false;
        }
        if (other.getCvss() == null ^ this.getCvss() == null) {
            return false;
        }
        if (other.getCvss() != null && !other.getCvss().equals(this.getCvss())) {
            return false;
        }
        if (other.getRelatedVulnerabilities() == null ^ this.getRelatedVulnerabilities() == null) {
            return false;
        }
        if (other.getRelatedVulnerabilities() != null && !other.getRelatedVulnerabilities().equals(this.getRelatedVulnerabilities())) {
            return false;
        }
        if (other.getVendor() == null ^ this.getVendor() == null) {
            return false;
        }
        if (other.getVendor() != null && !other.getVendor().equals(this.getVendor())) {
            return false;
        }
        if (other.getReferenceUrls() == null ^ this.getReferenceUrls() == null) {
            return false;
        }
        if (other.getReferenceUrls() != null && !other.getReferenceUrls().equals(this.getReferenceUrls())) {
            return false;
        }
        if (other.getFixAvailable() == null ^ this.getFixAvailable() == null) {
            return false;
        }
        if (other.getFixAvailable() != null && !other.getFixAvailable().equals(this.getFixAvailable())) {
            return false;
        }
        if (other.getEpssScore() == null ^ this.getEpssScore() == null) {
            return false;
        }
        if (other.getEpssScore() != null && !other.getEpssScore().equals(this.getEpssScore())) {
            return false;
        }
        if (other.getExploitAvailable() == null ^ this.getExploitAvailable() == null) {
            return false;
        }
        if (other.getExploitAvailable() != null && !other.getExploitAvailable().equals(this.getExploitAvailable())) {
            return false;
        }
        if (other.getCodeVulnerabilities() == null ^ this.getCodeVulnerabilities() == null) {
            return false;
        }
        return other.getCodeVulnerabilities() == null || other.getCodeVulnerabilities().equals(this.getCodeVulnerabilities());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getVulnerablePackages() == null ? 0 : this.getVulnerablePackages().hashCode());
        hashCode = 31 * hashCode + (this.getCvss() == null ? 0 : this.getCvss().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedVulnerabilities() == null ? 0 : this.getRelatedVulnerabilities().hashCode());
        hashCode = 31 * hashCode + (this.getVendor() == null ? 0 : this.getVendor().hashCode());
        hashCode = 31 * hashCode + (this.getReferenceUrls() == null ? 0 : this.getReferenceUrls().hashCode());
        hashCode = 31 * hashCode + (this.getFixAvailable() == null ? 0 : this.getFixAvailable().hashCode());
        hashCode = 31 * hashCode + (this.getEpssScore() == null ? 0 : this.getEpssScore().hashCode());
        hashCode = 31 * hashCode + (this.getExploitAvailable() == null ? 0 : this.getExploitAvailable().hashCode());
        hashCode = 31 * hashCode + (this.getCodeVulnerabilities() == null ? 0 : this.getCodeVulnerabilities().hashCode());
        return hashCode;
    }

    public Vulnerability clone() {
        try {
            return (Vulnerability)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VulnerabilityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

