/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.shield.model.Protection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListProtectionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Protection> protections;
    private String nextToken;

    public List<Protection> getProtections() {
        return this.protections;
    }

    public void setProtections(Collection<Protection> protections) {
        if (protections == null) {
            this.protections = null;
            return;
        }
        this.protections = new ArrayList<Protection>(protections);
    }

    public ListProtectionsResult withProtections(Protection ... protections) {
        if (this.protections == null) {
            this.setProtections(new ArrayList<Protection>(protections.length));
        }
        for (Protection ele : protections) {
            this.protections.add(ele);
        }
        return this;
    }

    public ListProtectionsResult withProtections(Collection<Protection> protections) {
        this.setProtections(protections);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListProtectionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProtections() != null) {
            sb.append("Protections: ").append(this.getProtections()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectionsResult)) {
            return false;
        }
        ListProtectionsResult other = (ListProtectionsResult)obj;
        if (other.getProtections() == null ^ this.getProtections() == null) {
            return false;
        }
        if (other.getProtections() != null && !other.getProtections().equals(this.getProtections())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProtections() == null ? 0 : this.getProtections().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListProtectionsResult clone() {
        try {
            return (ListProtectionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

