/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.conditions;

import com.amazonaws.services.stepfunctions.builder.conditions.BinaryCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.BinaryConditionBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NumericNode;

public final class NumericGreaterThanOrEqualCondition
implements BinaryCondition<String> {
    @JsonProperty(value="Variable")
    private final String variable;
    @JsonProperty(value="NumericGreaterThanEquals")
    private final NumericNode expectedValue;

    private NumericGreaterThanOrEqualCondition(Builder builder) {
        this.variable = builder.variable;
        this.expectedValue = builder.expectedValue;
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    @JsonIgnore
    public String getExpectedValue() {
        return this.expectedValue.asText();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends BinaryConditionBuilder {
        @JsonProperty(value="Variable")
        private String variable;
        @JsonProperty(value="NumericGreaterThanEquals")
        private NumericNode expectedValue;

        private Builder() {
        }

        @Override
        public Builder variable(String variable) {
            this.variable = variable;
            return this;
        }

        public Builder expectedValue(long expectedValue) {
            this.expectedValue = new LongNode(expectedValue);
            return this;
        }

        public Builder expectedValue(double expectedValue) {
            this.expectedValue = new DoubleNode(expectedValue);
            return this;
        }

        @Override
        BinaryConditionBuilder expectedValue(JsonNode expectedValue) {
            this.expectedValue = (NumericNode)expectedValue;
            return this;
        }

        @Override
        String type() {
            return "NumericGreaterThanEquals";
        }

        @Override
        public NumericGreaterThanOrEqualCondition build() {
            return new NumericGreaterThanOrEqualCondition(this);
        }
    }
}

