/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.curd.controller;

import com.anji.plus.gaea.annotation.AccessKey;
import com.anji.plus.gaea.annotation.Permission;
import com.anji.plus.gaea.annotation.log.GaeaAuditLog;
import com.anji.plus.gaea.bean.ResponseBean;
import com.anji.plus.gaea.curd.controller.BaseController;
import com.anji.plus.gaea.curd.dto.BaseDTO;
import com.anji.plus.gaea.curd.entity.BaseEntity;
import com.anji.plus.gaea.curd.params.PageParam;
import com.anji.plus.gaea.curd.service.GaeaBaseService;
import com.anji.plus.gaea.holder.UserContentHolder;
import com.anji.plus.gaea.utils.GaeaBeanUtils;
import com.anji.plus.gaea.utils.GaeaUtils;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class GaeaBaseController<P extends PageParam, T extends BaseEntity, D extends BaseDTO>
extends BaseController {
    public abstract GaeaBaseService<P, T> getService();

    public abstract T getEntity();

    public abstract D getDTO();

    @GetMapping(value={"/pageList"})
    @Permission(code="query", name="\u67e5\u8be2")
    @GaeaAuditLog(pageTitle="\u67e5\u8be2")
    public ResponseBean pageList(P param) {
        IPage<T> iPage = this.getService().page(param);
        List records = iPage.getRecords();
        List<?> list = GaeaBeanUtils.copyList(records, this.getDTO().getClass());
        this.pageResultHandler(list);
        Page pageDto = new Page();
        pageDto.setCurrent(iPage.getCurrent()).setRecords(list).setPages(iPage.getPages()).setTotal(iPage.getTotal()).setSize(iPage.getSize());
        return this.responseSuccessWithData(pageDto);
    }

    public List<D> pageResultHandler(List<D> list) {
        return list;
    }

    public D detailResultHandler(D detail) {
        return detail;
    }

    @GetMapping(value={"/{id}"})
    @AccessKey
    public ResponseBean detail(@PathVariable(value="id") Long id) {
        this.logger.info("{}\u6839\u636eID\u67e5\u8be2\u670d\u52a1\u5f00\u59cb\uff0cid\u4e3a\uff1a{}", (Object)this.getClass().getSimpleName(), (Object)id);
        T result = this.getService().selectOne(id);
        D dto = this.getDTO();
        GaeaBeanUtils.copyAndFormatter(result, dto);
        this.detailResultHandler(dto);
        ResponseBean responseBean = this.responseSuccessWithData(this.resultDtoHandle(dto));
        this.logger.info("{}\u6839\u636eID\u67e5\u8be2\u7ed3\u675f\uff0c\u7ed3\u679c\uff1a{}", (Object)this.getClass().getSimpleName(), (Object)GaeaUtils.toJSONString(responseBean));
        return responseBean;
    }

    protected D resultDtoHandle(D d) {
        return d;
    }

    @PostMapping
    @Permission(code="insert", name="\u65b0\u589e")
    @GaeaAuditLog(pageTitle="\u65b0\u589e")
    public ResponseBean insert(@Validated @RequestBody D dto) {
        this.logger.info("{}\u65b0\u589e\u670d\u52a1\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}", (Object)this.getClass().getSimpleName(), (Object)GaeaUtils.toJSONString(dto));
        ResponseBean responseBean = this.responseSuccess();
        T entity = this.getEntity();
        BeanUtils.copyProperties(dto, entity);
        this.getService().insert(entity);
        this.logger.info("{}\u65b0\u589e\u670d\u52a1\u7ed3\u675f\uff0c\u7ed3\u679c\uff1a{}", (Object)this.getClass().getSimpleName(), (Object)GaeaUtils.toJSONString(responseBean));
        return responseBean;
    }

    @PutMapping
    @Permission(code="update", name="\u66f4\u65b0")
    @GaeaAuditLog(pageTitle="\u4fee\u6539")
    public ResponseBean update(@Validated @RequestBody D dto) {
        String username = UserContentHolder.getContext().getUsername();
        this.logger.info("{}\u66f4\u65b0\u670d\u52a1\u5f00\u59cb,\u66f4\u65b0\u4eba\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{this.getClass().getSimpleName(), username, GaeaUtils.toJSONString(dto)});
        T entity = this.getEntity();
        BeanUtils.copyProperties(dto, entity);
        this.getService().update(entity);
        this.logger.info("{}\u66f4\u65b0\u670d\u52a1\u7ed3\u675f\uff0c\u7ed3\u679c\uff1a{}", (Object)this.getClass().getSimpleName(), (Object)GaeaUtils.toJSONString(entity));
        return this.responseSuccess();
    }

    @DeleteMapping(value={"/{id}"})
    @Permission(code="delete", name="\u5220\u9664")
    @GaeaAuditLog(pageTitle="\u5220\u9664")
    public ResponseBean deleteById(@PathVariable(value="id") Long id) {
        this.logger.info("{}\u5220\u9664\u670d\u52a1\u5f00\u59cb\uff0c\u53c2\u6570ID\uff1a{}", (Object)this.getClass().getSimpleName(), (Object)id);
        this.getService().deleteById(id);
        this.logger.info("{}\u5220\u9664\u670d\u52a1\u7ed3\u675f", (Object)this.getClass().getSimpleName());
        return this.responseSuccess();
    }

    @PostMapping(value={"/delete/batch"})
    @Permission(code="delete", name="\u5220\u9664")
    @GaeaAuditLog(pageTitle="\u6279\u91cf\u5220\u9664")
    public ResponseBean deleteBatchIds(@RequestBody List<Serializable> ids) {
        this.logger.info("{}\u6279\u91cf\u5220\u9664\u670d\u52a1\u5f00\u59cb\uff0c\u6279\u91cf\u53c2\u6570Ids\uff1a{}", (Object)this.getClass().getSimpleName(), (Object)GaeaUtils.toJSONString(ids));
        boolean deleteCount = this.getService().deleteByIds(ids);
        ResponseBean responseBean = this.responseSuccessWithData(deleteCount);
        this.logger.info("{}\u6279\u91cf\u5220\u9664\u670d\u52a1\u7ed3\u675f\uff0c\u7ed3\u679c\uff1a{}", (Object)this.getClass().getSimpleName(), (Object)GaeaUtils.toJSONString(responseBean));
        return responseBean;
    }
}

