/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.utils;

import com.anji.plus.gaea.utils.GaeaUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;

public abstract class GaeaDateUtils {
    public static String toString(Date date, String pattern) {
        LocalDateTime localDateTime = GaeaDateUtils.toLocalDateTime(date);
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String toString(LocalDate localDate, String pattern) {
        return localDate.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDate fromString(String dateString, String pattern) {
        return LocalDate.parse(dateString, DateTimeFormatter.ofPattern(pattern));
    }

    public static Date toDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static String formatFromSecond(long seconds) {
        long resultSeconds;
        long minus;
        long hours;
        StringBuilder builder = new StringBuilder();
        long hourSeconds = 3600L;
        long daySeconds = hourSeconds * 24L;
        long days = seconds / daySeconds;
        if (days > 0L) {
            builder.append(days).append("${day)");
        }
        if ((hours = seconds % daySeconds / hourSeconds) > 0L) {
            builder.append(hours).append("${hour}");
        }
        if ((minus = seconds % daySeconds % hourSeconds / 60L) > 0L) {
            builder.append(minus).append("${minute}");
        }
        if ((resultSeconds = seconds % daySeconds % hourSeconds % 60L) > 0L) {
            builder.append(resultSeconds).append("${second}");
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("username", "admin");
        map.put("age", 24);
        String s = GaeaUtils.replaceFormatString("${username} is ${age}", map);
        System.out.println(s);
        String s1 = GaeaDateUtils.formatFromSecond(40000L);
        System.out.println(s1);
    }
}

