/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.AbstractPropertyEditorComponent;
import com.atomikos.beans.CheckboxComponent;
import com.atomikos.beans.ComboBoxComponent;
import com.atomikos.beans.DefaultPropertyEditor;
import com.atomikos.beans.Editor;
import com.atomikos.beans.EditorImp;
import com.atomikos.beans.IndexedProperty;
import com.atomikos.beans.PrimitiveClasses;
import com.atomikos.beans.Property;
import com.atomikos.beans.PropertyException;
import com.atomikos.beans.ReadOnlyException;
import com.atomikos.beans.TableComponent;
import com.atomikos.beans.TextFieldComponent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class PropertyImp
implements Property {
    private PropertyDescriptor descriptor_;
    private Object bean_;
    private Editor editor_;

    PropertyImp(Object bean, PropertyDescriptor descriptor) throws PropertyException {
        this.descriptor_ = descriptor;
        this.bean_ = bean;
        try {
            this.editor_ = this.createEditor();
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
    }

    protected PropertyDescriptor getPropertyDescriptor() {
        return this.descriptor_;
    }

    protected Object getBean() {
        return this.bean_;
    }

    public String getName() {
        return this.descriptor_.getName();
    }

    public String getDescription() {
        String ret = null;
        ret = this.descriptor_.getShortDescription();
        if (ret == null) {
            ret = this.getName();
        }
        return ret;
    }

    public Class getType() {
        return this.descriptor_.getPropertyType();
    }

    public boolean isExpert() {
        return this.descriptor_.isExpert();
    }

    public boolean isPreferred() {
        return this.descriptor_.isPreferred();
    }

    public boolean isHidden() {
        return this.descriptor_.isHidden();
    }

    public boolean isReadOnly() {
        return this.descriptor_.getWriteMethod() == null;
    }

    public Object getValue() throws PropertyException {
        Object ret = null;
        try {
            Method method = this.descriptor_.getReadMethod();
            ret = method.invoke(this.bean_, null);
        }
        catch (InvocationTargetException e) {
            throw new PropertyException("Error getting value of " + this.descriptor_.getName() + " " + e.getMessage(), e.getTargetException());
        }
        catch (Exception err) {
            throw new PropertyException("Error getting value of " + this.descriptor_.getName(), err);
        }
        return ret;
    }

    public IndexedProperty getIndexedProperty() {
        return null;
    }

    public void setValue(Object arg) throws ReadOnlyException, PropertyException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException("Property is readonly");
        }
        try {
            Object[] args = new Object[]{arg};
            Method method = this.descriptor_.getWriteMethod();
            method.invoke(this.bean_, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PropertyException("Error in setting value", e);
        }
    }

    private Editor createEditor() throws PropertyException {
        EditorImp ret = null;
        AbstractPropertyEditorComponent component = null;
        Class wrapperClass = PrimitiveClasses.getWrapperClass(this.getType());
        if (wrapperClass != null) {
            component = wrapperClass.equals(Boolean.class) ? new CheckboxComponent(this) : new TextFieldComponent(this, PrimitiveClasses.isDecimalClass(wrapperClass));
        } else if (String.class.equals((Object)this.getType())) {
            component = this.getAllowedValues() != null ? new ComboBoxComponent(this) : new TextFieldComponent(this);
        } else if (this.getIndexedProperty() != null) {
            component = new TableComponent(this.getIndexedProperty());
        }
        if (component != null) {
            DefaultPropertyEditor pedit = new DefaultPropertyEditor(component, this.getAllowedValues());
            ret = new EditorImp(this, pedit);
        }
        return ret;
    }

    public Editor getEditor() {
        return this.editor_;
    }

    public String[] getAllowedValues() {
        String[] ret = null;
        PropertyEditor pedit = null;
        try {
            Class<?> clazz = this.descriptor_.getPropertyEditorClass();
            if (clazz != null) {
                pedit = (PropertyEditor)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pedit == null) {
            pedit = PropertyEditorManager.findEditor(this.descriptor_.getPropertyType());
        }
        if (pedit != null) {
            ret = pedit.getTags();
        }
        return ret;
    }
}

