/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.extra;

import com.atomikos.jms.extra.JmsSenderTemplateCallback;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;

abstract class MessageCallback
implements JmsSenderTemplateCallback {
    private final Destination replyToDestination;
    private final Destination destination;
    private final int priority;
    private final long ttl;
    private final int deliveryMode;

    protected MessageCallback(Destination destination, Destination replyToDestination, int deliveryMode, int priority, long ttl) {
        this.destination = destination;
        this.replyToDestination = replyToDestination;
        this.priority = priority;
        this.ttl = ttl;
        this.deliveryMode = deliveryMode;
    }

    protected void sendMessage(Message m, Session s) throws JMSException {
        if (this.replyToDestination != null) {
            m.setJMSReplyTo(this.replyToDestination);
        }
        MessageProducer mp = s.createProducer(this.destination);
        mp.send(m, this.deliveryMode, this.priority, this.ttl);
        mp.close();
    }

    @Override
    public void doInJmsSession(Session session) throws JMSException {
        this.sendMessage(this.createMessage(session), session);
    }

    abstract Message createMessage(Session var1) throws JMSException;
}

