/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson.implementation;

import com.azure.core.implementation.GeoObjectHelper;
import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoCollection;
import com.azure.core.models.GeoLineString;
import com.azure.core.models.GeoLineStringCollection;
import com.azure.core.models.GeoLinearRing;
import com.azure.core.models.GeoObject;
import com.azure.core.models.GeoObjectType;
import com.azure.core.models.GeoPoint;
import com.azure.core.models.GeoPointCollection;
import com.azure.core.models.GeoPolygon;
import com.azure.core.models.GeoPolygonCollection;
import com.azure.core.models.GeoPosition;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class GeoJsonSerializer
extends JsonSerializer<GeoObject> {
    private static final ClientLogger LOGGER = new ClientLogger(GeoJsonSerializer.class);
    private static final SimpleModule MODULE = new SimpleModule().addSerializer(GeoObject.class, (JsonSerializer)new GeoJsonSerializer());

    GeoJsonSerializer() {
    }

    public static SimpleModule getModule() {
        return MODULE;
    }

    public void serialize(GeoObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        GeoJsonSerializer.write(value, gen);
    }

    private static void write(GeoObject value, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        if (value instanceof GeoPoint) {
            GeoJsonSerializer.writeType(GeoObjectType.POINT, gen);
            gen.writeFieldName("coordinates");
            GeoJsonSerializer.writePosition(((GeoPoint)value).getCoordinates(), gen);
        } else if (value instanceof GeoLineString) {
            GeoJsonSerializer.writeType(GeoObjectType.LINE_STRING, gen);
            gen.writeFieldName("coordinates");
            GeoJsonSerializer.writePositions(((GeoLineString)value).getCoordinates(), gen);
        } else if (value instanceof GeoPolygon) {
            GeoJsonSerializer.writeType(GeoObjectType.POLYGON, gen);
            gen.writeArrayFieldStart("coordinates");
            for (GeoLinearRing ring : ((GeoPolygon)value).getRings()) {
                GeoJsonSerializer.writePositions(ring.getCoordinates(), gen);
            }
            gen.writeEndArray();
        } else if (value instanceof GeoPointCollection) {
            GeoJsonSerializer.writeType(GeoObjectType.MULTI_POINT, gen);
            gen.writeArrayFieldStart("coordinates");
            for (GeoPoint point : ((GeoPointCollection)value).getPoints()) {
                GeoJsonSerializer.writePosition(point.getCoordinates(), gen);
            }
            gen.writeEndArray();
        } else if (value instanceof GeoLineStringCollection) {
            GeoJsonSerializer.writeType(GeoObjectType.MULTI_LINE_STRING, gen);
            gen.writeArrayFieldStart("coordinates");
            for (GeoLineString line : ((GeoLineStringCollection)value).getLines()) {
                GeoJsonSerializer.writePositions(line.getCoordinates(), gen);
            }
            gen.writeEndArray();
        } else if (value instanceof GeoPolygonCollection) {
            GeoJsonSerializer.writeType(GeoObjectType.MULTI_POLYGON, gen);
            gen.writeArrayFieldStart("coordinates");
            for (GeoPolygon polygon : ((GeoPolygonCollection)value).getPolygons()) {
                gen.writeStartArray();
                for (GeoLinearRing ring : polygon.getRings()) {
                    GeoJsonSerializer.writePositions(ring.getCoordinates(), gen);
                }
                gen.writeEndArray();
            }
            gen.writeEndArray();
        } else if (value instanceof GeoCollection) {
            GeoJsonSerializer.writeType(GeoObjectType.GEOMETRY_COLLECTION, gen);
            gen.writeArrayFieldStart("geometries");
            for (GeoObject geoObject : ((GeoCollection)value).getGeometries()) {
                GeoJsonSerializer.write(geoObject, gen);
            }
            gen.writeEndArray();
        } else {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("Geo type '%s' isn't supported.", value.getClass().getName())));
        }
        GeoJsonSerializer.writeBoundingBox(value.getBoundingBox(), gen);
        GeoJsonSerializer.writeAdditionalProperties(GeoObjectHelper.getCustomProperties((GeoObject)value), gen);
        gen.writeEndObject();
    }

    private static void writePositions(List<GeoPosition> positions, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        for (GeoPosition position : positions) {
            GeoJsonSerializer.writePosition(position, gen);
        }
        gen.writeEndArray();
    }

    private static void writePosition(GeoPosition position, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        gen.writeNumber(position.getLongitude());
        gen.writeNumber(position.getLatitude());
        Double altitude = position.getAltitude();
        if (altitude != null) {
            gen.writeNumber(altitude.doubleValue());
        }
        gen.writeEndArray();
    }

    private static void writeType(GeoObjectType type, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", type.toString());
    }

    private static void writeBoundingBox(GeoBoundingBox boundingBox, JsonGenerator gen) throws IOException {
        if (boundingBox == null) {
            return;
        }
        gen.writeArrayFieldStart("bbox");
        gen.writeNumber(boundingBox.getWest());
        gen.writeNumber(boundingBox.getSouth());
        Double minAltitude = boundingBox.getMinAltitude();
        if (minAltitude != null) {
            gen.writeNumber(minAltitude.doubleValue());
        }
        gen.writeNumber(boundingBox.getEast());
        gen.writeNumber(boundingBox.getNorth());
        Double maxAltitude = boundingBox.getMaxAltitude();
        if (maxAltitude != null) {
            gen.writeNumber(maxAltitude.doubleValue());
        }
        gen.writeEndArray();
    }

    private static void writeAdditionalProperties(Map<String, Object> properties, JsonGenerator gen) throws IOException {
        if (CoreUtils.isNullOrEmpty(properties)) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            gen.writeFieldName(property.getKey());
            gen.writeObject(property.getValue());
        }
    }
}

