/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.credential.AccessToken;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public final class MSIToken
extends AccessToken {
    private static final OffsetDateTime EPOCH = OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="expires_on")
    private String expiresOn;

    @JsonCreator
    public MSIToken(@JsonProperty(value="access_token") String token, @JsonProperty(value="expires_on") String expiresOn) {
        super(token, EPOCH.plusSeconds(MSIToken.parseDateToEpochSeconds(expiresOn)));
        this.accessToken = token;
        this.expiresOn = expiresOn;
    }

    public String getToken() {
        return this.accessToken;
    }

    private static Long parseDateToEpochSeconds(String dateTime) {
        ClientLogger logger = new ClientLogger(MSIToken.class);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("M/d/yyyy H:mm:ss XXX");
        DateTimeFormatter dtfWindows = DateTimeFormatter.ofPattern("M/d/yyyy h:mm:ss a XXX");
        try {
            return Long.parseLong(dateTime);
        }
        catch (NumberFormatException e) {
            logger.error(e.getMessage());
            try {
                return Instant.from(dtf.parse(dateTime)).getEpochSecond();
            }
            catch (DateTimeParseException e2) {
                logger.error(e2.getMessage());
                try {
                    return Instant.from(dtfWindows.parse(dateTime)).getEpochSecond();
                }
                catch (DateTimeParseException e3) {
                    logger.error(e3.getMessage());
                    throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unable to parse date time " + dateTime));
                }
            }
        }
    }
}

