/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.msalextensions.cachepersister;

import com.azure.identity.implementation.msalextensions.cachepersister.CacheProtectorBase;
import com.azure.identity.implementation.msalextensions.cachepersister.PlatformNotSupportedException;
import com.azure.identity.implementation.msalextensions.cachepersister.windows.WindowsDPAPICacheProtector;
import com.sun.jna.Platform;
import java.io.IOException;
import java.nio.file.Paths;

public final class CachePersister {
    private CacheProtectorBase cacheProtector;

    private CachePersister(CacheProtectorBase cacheProtector) {
        this.cacheProtector = cacheProtector;
    }

    public byte[] readCache() {
        return this.cacheProtector.readCache();
    }

    public void writeCache(byte[] data) {
        this.cacheProtector.writeCache(data);
    }

    public boolean deleteCache() {
        return this.cacheProtector.deleteCache();
    }

    public static class Builder {
        private String cacheLocation = Platform.isWindows() ? Paths.get(System.getProperty("user.home"), "AppData", "Local", ".IdentityService", "msal.cache").toString() : Paths.get(System.getProperty("user.home"), "msal.cache").toString();
        private String lockfileLocation = this.cacheLocation + ".lockfile";

        public Builder cacheLocation(String cacheLocation) {
            this.cacheLocation = cacheLocation;
            this.lockfileLocation = cacheLocation + ".lockfile";
            return this;
        }

        public Builder lockfileLocation(String lockfileLocation) {
            this.lockfileLocation = lockfileLocation;
            return this;
        }

        public CachePersister build() throws RuntimeException {
            if (Platform.isWindows()) {
                try {
                    return new CachePersister(new WindowsDPAPICacheProtector(this.cacheLocation, this.lockfileLocation));
                }
                catch (IOException e) {
                    throw new RuntimeException("IO Exception in creating the WindowsDPAPICacheProtector");
                }
            }
            throw new PlatformNotSupportedException("Platform is not supported");
        }
    }
}

