/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.msalextensions.cachepersister.windows;

import com.azure.identity.implementation.msalextensions.cachepersister.CacheProtectorBase;
import com.sun.jna.platform.win32.Crypt32Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class WindowsDPAPICacheProtector
extends CacheProtectorBase {
    private final String cacheFilename;
    private File cacheFile;

    public WindowsDPAPICacheProtector(String cacheLocation, String lockfileLocation) throws IOException {
        super(lockfileLocation);
        this.cacheFilename = cacheLocation;
        this.cacheFile = new File(this.cacheFilename);
        this.makeSureFileExists();
    }

    @Override
    protected byte[] unprotect() throws IOException {
        this.makeSureFileExists();
        byte[] encryptedBytes = new byte[(int)this.cacheFile.length()];
        try (FileInputStream stream = new FileInputStream(this.cacheFile);){
            for (int read = 0; read != encryptedBytes.length; read += stream.read(encryptedBytes)) {
            }
        }
        byte[] decryptedBytes = Crypt32Util.cryptUnprotectData((byte[])encryptedBytes);
        return decryptedBytes;
    }

    @Override
    protected void protect(byte[] data) throws IOException {
        this.makeSureFileExists();
        byte[] encryptedBytes = Crypt32Util.cryptProtectData((byte[])data);
        try (FileOutputStream stream = new FileOutputStream(this.cacheFile);){
            stream.write(encryptedBytes);
        }
    }

    private void makeSureFileExists() throws IOException {
        if (!this.cacheFile.exists()) {
            this.cacheFile.createNewFile();
            this.protect(" ".getBytes("UTF-8"));
        }
    }

    @Override
    public void deleteCacheHelper() {
        if (this.cacheFile.exists()) {
            this.cacheFile.delete();
        }
    }
}

