// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.search.documents.implementation.models.AutocompleteRequest;
import com.azure.search.documents.implementation.models.IndexBatch;
import com.azure.search.documents.implementation.models.RequestOptions;
import com.azure.search.documents.implementation.models.SearchDocumentsResult;
import com.azure.search.documents.implementation.models.SearchErrorException;
import com.azure.search.documents.implementation.models.SearchRequest;
import com.azure.search.documents.implementation.models.SuggestDocumentsResult;
import com.azure.search.documents.implementation.models.SuggestRequest;
import com.azure.search.documents.models.AutocompleteMode;
import com.azure.search.documents.models.AutocompleteResult;
import com.azure.search.documents.models.IndexDocumentsResult;
import com.azure.search.documents.models.QueryType;
import com.azure.search.documents.models.ScoringStatistics;
import com.azure.search.documents.models.SearchMode;
import com.azure.search.documents.models.SemanticErrorMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in Documents. */
public final class DocumentsImpl {

    /** The proxy service used to perform REST calls. */
    private final DocumentsService service;

    /** The service client containing this operation class. */
    private final SearchIndexClientImpl client;

    /**
     * Initializes an instance of DocumentsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DocumentsImpl(SearchIndexClientImpl client) {
        this.service =
                RestProxy.create(DocumentsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SearchIndexClientDocuments to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{endpoint}/indexes('{indexName}')")
    @ServiceInterface(name = "SearchIndexClientDoc")
    public interface DocumentsService {

        @Get("/docs/$count")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<Long>> count(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/docs/$count")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<Long> countSync(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/docs")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<SearchDocumentsResult>> searchGet(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @QueryParam("search") String searchText,
                @QueryParam("$count") Boolean includeTotalCount,
                @QueryParam(value = "facet", multipleQueryParams = true) List<String> facets,
                @QueryParam("$filter") String filter,
                @QueryParam("highlight") String highlightFields,
                @QueryParam("highlightPostTag") String highlightPostTag,
                @QueryParam("highlightPreTag") String highlightPreTag,
                @QueryParam("minimumCoverage") Double minimumCoverage,
                @QueryParam("$orderby") String orderBy,
                @QueryParam("queryType") QueryType queryType,
                @QueryParam(value = "scoringParameter", multipleQueryParams = true) List<String> scoringParameters,
                @QueryParam("scoringProfile") String scoringProfile,
                @QueryParam("searchFields") String searchFields,
                @QueryParam("searchMode") SearchMode searchMode,
                @QueryParam("scoringStatistics") ScoringStatistics scoringStatistics,
                @QueryParam("sessionId") String sessionId,
                @QueryParam("$select") String select,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$top") Integer top,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("semanticConfiguration") String semanticConfiguration,
                @QueryParam("semanticErrorHandling") SemanticErrorMode semanticErrorHandling,
                @QueryParam("semanticMaxWaitInMilliseconds") Integer semanticMaxWaitInMilliseconds,
                @QueryParam("answers") String answers,
                @QueryParam("captions") String captions,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/docs")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<SearchDocumentsResult> searchGetSync(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @QueryParam("search") String searchText,
                @QueryParam("$count") Boolean includeTotalCount,
                @QueryParam(value = "facet", multipleQueryParams = true) List<String> facets,
                @QueryParam("$filter") String filter,
                @QueryParam("highlight") String highlightFields,
                @QueryParam("highlightPostTag") String highlightPostTag,
                @QueryParam("highlightPreTag") String highlightPreTag,
                @QueryParam("minimumCoverage") Double minimumCoverage,
                @QueryParam("$orderby") String orderBy,
                @QueryParam("queryType") QueryType queryType,
                @QueryParam(value = "scoringParameter", multipleQueryParams = true) List<String> scoringParameters,
                @QueryParam("scoringProfile") String scoringProfile,
                @QueryParam("searchFields") String searchFields,
                @QueryParam("searchMode") SearchMode searchMode,
                @QueryParam("scoringStatistics") ScoringStatistics scoringStatistics,
                @QueryParam("sessionId") String sessionId,
                @QueryParam("$select") String select,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$top") Integer top,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("semanticConfiguration") String semanticConfiguration,
                @QueryParam("semanticErrorHandling") SemanticErrorMode semanticErrorHandling,
                @QueryParam("semanticMaxWaitInMilliseconds") Integer semanticMaxWaitInMilliseconds,
                @QueryParam("answers") String answers,
                @QueryParam("captions") String captions,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/docs/search.post.search")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<SearchDocumentsResult>> searchPost(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") SearchRequest searchRequest,
                Context context);

        @Post("/docs/search.post.search")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<SearchDocumentsResult> searchPostSync(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") SearchRequest searchRequest,
                Context context);

        @Get("/docs('{key}')")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<Map<String, Object>>> get(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @PathParam("key") String key,
                @QueryParam("$select") String selectedFields,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/docs('{key}')")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<Map<String, Object>> getSync(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @PathParam("key") String key,
                @QueryParam("$select") String selectedFields,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/docs/search.suggest")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<SuggestDocumentsResult>> suggestGet(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @QueryParam("search") String searchText,
                @QueryParam("suggesterName") String suggesterName,
                @QueryParam("$filter") String filter,
                @QueryParam("fuzzy") Boolean useFuzzyMatching,
                @QueryParam("highlightPostTag") String highlightPostTag,
                @QueryParam("highlightPreTag") String highlightPreTag,
                @QueryParam("minimumCoverage") Double minimumCoverage,
                @QueryParam("$orderby") String orderBy,
                @QueryParam("searchFields") String searchFields,
                @QueryParam("$select") String select,
                @QueryParam("$top") Integer top,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/docs/search.suggest")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<SuggestDocumentsResult> suggestGetSync(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @QueryParam("search") String searchText,
                @QueryParam("suggesterName") String suggesterName,
                @QueryParam("$filter") String filter,
                @QueryParam("fuzzy") Boolean useFuzzyMatching,
                @QueryParam("highlightPostTag") String highlightPostTag,
                @QueryParam("highlightPreTag") String highlightPreTag,
                @QueryParam("minimumCoverage") Double minimumCoverage,
                @QueryParam("$orderby") String orderBy,
                @QueryParam("searchFields") String searchFields,
                @QueryParam("$select") String select,
                @QueryParam("$top") Integer top,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/docs/search.post.suggest")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<SuggestDocumentsResult>> suggestPost(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") SuggestRequest suggestRequest,
                Context context);

        @Post("/docs/search.post.suggest")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<SuggestDocumentsResult> suggestPostSync(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") SuggestRequest suggestRequest,
                Context context);

        @Post("/docs/search.index")
        @ExpectedResponses({200, 207})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<IndexDocumentsResult>> index(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") IndexBatch batch,
                Context context);

        @Post("/docs/search.index")
        @ExpectedResponses({200, 207})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<IndexDocumentsResult> indexSync(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") IndexBatch batch,
                Context context);

        @Get("/docs/search.autocomplete")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<AutocompleteResult>> autocompleteGet(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @QueryParam("search") String searchText,
                @QueryParam("suggesterName") String suggesterName,
                @QueryParam("autocompleteMode") AutocompleteMode autocompleteMode,
                @QueryParam("$filter") String filter,
                @QueryParam("fuzzy") Boolean useFuzzyMatching,
                @QueryParam("highlightPostTag") String highlightPostTag,
                @QueryParam("highlightPreTag") String highlightPreTag,
                @QueryParam("minimumCoverage") Double minimumCoverage,
                @QueryParam("searchFields") String searchFields,
                @QueryParam("$top") Integer top,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/docs/search.autocomplete")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<AutocompleteResult> autocompleteGetSync(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @QueryParam("search") String searchText,
                @QueryParam("suggesterName") String suggesterName,
                @QueryParam("autocompleteMode") AutocompleteMode autocompleteMode,
                @QueryParam("$filter") String filter,
                @QueryParam("fuzzy") Boolean useFuzzyMatching,
                @QueryParam("highlightPostTag") String highlightPostTag,
                @QueryParam("highlightPreTag") String highlightPreTag,
                @QueryParam("minimumCoverage") Double minimumCoverage,
                @QueryParam("searchFields") String searchFields,
                @QueryParam("$top") Integer top,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/docs/search.post.autocomplete")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Mono<Response<AutocompleteResult>> autocompletePost(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") AutocompleteRequest autocompleteRequest,
                Context context);

        @Post("/docs/search.post.autocomplete")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(SearchErrorException.class)
        Response<AutocompleteResult> autocompletePostSync(
                @HostParam("endpoint") String endpoint,
                @HostParam("indexName") String indexName,
                @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                @BodyParam("application/json") AutocompleteRequest autocompleteRequest,
                Context context);
    }

    /**
     * Queries the number of documents in the index.
     *
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Long>> countWithResponseAsync(RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(
                context ->
                        service.count(
                                this.client.getEndpoint(),
                                this.client.getIndexName(),
                                xMsClientRequestId,
                                this.client.getApiVersion(),
                                accept,
                                context));
    }

    /**
     * Queries the number of documents in the index.
     *
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Long>> countWithResponseAsync(RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.count(
                this.client.getEndpoint(),
                this.client.getIndexName(),
                xMsClientRequestId,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Queries the number of documents in the index.
     *
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Long> countAsync(RequestOptions requestOptions) {
        return countWithResponseAsync(requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Queries the number of documents in the index.
     *
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Long> countAsync(RequestOptions requestOptions, Context context) {
        return countWithResponseAsync(requestOptions, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Queries the number of documents in the index.
     *
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Long> countWithResponse(RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.countSync(
                this.client.getEndpoint(),
                this.client.getIndexName(),
                xMsClientRequestId,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Queries the number of documents in the index.
     *
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public long count(RequestOptions requestOptions) {
        return countWithResponse(requestOptions, Context.NONE).getValue();
    }

    /**
     * Searches for documents in the index.
     *
     * @param searchRequest The definition of the Search request.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing search results from an index along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchDocumentsResult>> searchPostWithResponseAsync(
            SearchRequest searchRequest, RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(
                context ->
                        service.searchPost(
                                this.client.getEndpoint(),
                                this.client.getIndexName(),
                                this.client.getApiVersion(),
                                xMsClientRequestId,
                                accept,
                                searchRequest,
                                context));
    }

    /**
     * Searches for documents in the index.
     *
     * @param searchRequest The definition of the Search request.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing search results from an index along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SearchDocumentsResult>> searchPostWithResponseAsync(
            SearchRequest searchRequest, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.searchPost(
                this.client.getEndpoint(),
                this.client.getIndexName(),
                this.client.getApiVersion(),
                xMsClientRequestId,
                accept,
                searchRequest,
                context);
    }

    /**
     * Searches for documents in the index.
     *
     * @param searchRequest The definition of the Search request.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing search results from an index on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchDocumentsResult> searchPostAsync(SearchRequest searchRequest, RequestOptions requestOptions) {
        return searchPostWithResponseAsync(searchRequest, requestOptions)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Searches for documents in the index.
     *
     * @param searchRequest The definition of the Search request.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing search results from an index on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SearchDocumentsResult> searchPostAsync(
            SearchRequest searchRequest, RequestOptions requestOptions, Context context) {
        return searchPostWithResponseAsync(searchRequest, requestOptions, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Searches for documents in the index.
     *
     * @param searchRequest The definition of the Search request.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing search results from an index along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SearchDocumentsResult> searchPostWithResponse(
            SearchRequest searchRequest, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.searchPostSync(
                this.client.getEndpoint(),
                this.client.getIndexName(),
                this.client.getApiVersion(),
                xMsClientRequestId,
                accept,
                searchRequest,
                context);
    }

    /**
     * Searches for documents in the index.
     *
     * @param searchRequest The definition of the Search request.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing search results from an index.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SearchDocumentsResult searchPost(SearchRequest searchRequest, RequestOptions requestOptions) {
        return searchPostWithResponse(searchRequest, requestOptions, Context.NONE).getValue();
    }

    /**
     * Retrieves a document from the index.
     *
     * @param key The key of the document to retrieve.
     * @param selectedFields List of field names to retrieve for the document; Any field not retrieved will be missing
     *     from the returned document.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a document retrieved via a document lookup operation along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> getWithResponseAsync(
            String key, List<String> selectedFields, RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        String selectedFieldsConverted =
                (selectedFields == null)
                        ? null
                        : selectedFields.stream()
                                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                                .collect(Collectors.joining(","));
        return FluxUtil.withContext(
                context ->
                        service.get(
                                this.client.getEndpoint(),
                                this.client.getIndexName(),
                                key,
                                selectedFieldsConverted,
                                this.client.getApiVersion(),
                                xMsClientRequestId,
                                accept,
                                context));
    }

    /**
     * Retrieves a document from the index.
     *
     * @param key The key of the document to retrieve.
     * @param selectedFields List of field names to retrieve for the document; Any field not retrieved will be missing
     *     from the returned document.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a document retrieved via a document lookup operation along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> getWithResponseAsync(
            String key, List<String> selectedFields, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        String selectedFieldsConverted =
                (selectedFields == null)
                        ? null
                        : selectedFields.stream()
                                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                                .collect(Collectors.joining(","));
        return service.get(
                this.client.getEndpoint(),
                this.client.getIndexName(),
                key,
                selectedFieldsConverted,
                this.client.getApiVersion(),
                xMsClientRequestId,
                accept,
                context);
    }

    /**
     * Retrieves a document from the index.
     *
     * @param key The key of the document to retrieve.
     * @param selectedFields List of field names to retrieve for the document; Any field not retrieved will be missing
     *     from the returned document.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a document retrieved via a document lookup operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> getAsync(String key, List<String> selectedFields, RequestOptions requestOptions) {
        return getWithResponseAsync(key, selectedFields, requestOptions)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves a document from the index.
     *
     * @param key The key of the document to retrieve.
     * @param selectedFields List of field names to retrieve for the document; Any field not retrieved will be missing
     *     from the returned document.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a document retrieved via a document lookup operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> getAsync(
            String key, List<String> selectedFields, RequestOptions requestOptions, Context context) {
        return getWithResponseAsync(key, selectedFields, requestOptions, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves a document from the index.
     *
     * @param key The key of the document to retrieve.
     * @param selectedFields List of field names to retrieve for the document; Any field not retrieved will be missing
     *     from the returned document.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a document retrieved via a document lookup operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Map<String, Object>> getWithResponse(
            String key, List<String> selectedFields, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        String selectedFieldsConverted =
                (selectedFields == null)
                        ? null
                        : selectedFields.stream()
                                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                                .collect(Collectors.joining(","));
        return service.getSync(
                this.client.getEndpoint(),
                this.client.getIndexName(),
                key,
                selectedFieldsConverted,
                this.client.getApiVersion(),
                xMsClientRequestId,
                accept,
                context);
    }

    /**
     * Retrieves a document from the index.
     *
     * @param key The key of the document to retrieve.
     * @param selectedFields List of field names to retrieve for the document; Any field not retrieved will be missing
     *     from the returned document.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a document retrieved via a document lookup operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Map<String, Object> get(String key, List<String> selectedFields, RequestOptions requestOptions) {
        return getWithResponse(key, selectedFields, requestOptions, Context.NONE).getValue();
    }

    /**
     * Suggests documents in the index that match the given partial query text.
     *
     * @param suggestRequest The Suggest request.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing suggestion query results from an index along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SuggestDocumentsResult>> suggestPostWithResponseAsync(
            SuggestRequest suggestRequest, RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(
                context ->
                        service.suggestPost(
                                this.client.getEndpoint(),
                                this.client.getIndexName(),
                                this.client.getApiVersion(),
                                xMsClientRequestId,
                                accept,
                                suggestRequest,
                                context));
    }

    /**
     * Suggests documents in the index that match the given partial query text.
     *
     * @param suggestRequest The Suggest request.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing suggestion query results from an index along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SuggestDocumentsResult>> suggestPostWithResponseAsync(
            SuggestRequest suggestRequest, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.suggestPost(
                this.client.getEndpoint(),
                this.client.getIndexName(),
                this.client.getApiVersion(),
                xMsClientRequestId,
                accept,
                suggestRequest,
                context);
    }

    /**
     * Suggests documents in the index that match the given partial query text.
     *
     * @param suggestRequest The Suggest request.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing suggestion query results from an index on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SuggestDocumentsResult> suggestPostAsync(SuggestRequest suggestRequest, RequestOptions requestOptions) {
        return suggestPostWithResponseAsync(suggestRequest, requestOptions)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Suggests documents in the index that match the given partial query text.
     *
     * @param suggestRequest The Suggest request.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing suggestion query results from an index on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SuggestDocumentsResult> suggestPostAsync(
            SuggestRequest suggestRequest, RequestOptions requestOptions, Context context) {
        return suggestPostWithResponseAsync(suggestRequest, requestOptions, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Suggests documents in the index that match the given partial query text.
     *
     * @param suggestRequest The Suggest request.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing suggestion query results from an index along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SuggestDocumentsResult> suggestPostWithResponse(
            SuggestRequest suggestRequest, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.suggestPostSync(
                this.client.getEndpoint(),
                this.client.getIndexName(),
                this.client.getApiVersion(),
                xMsClientRequestId,
                accept,
                suggestRequest,
                context);
    }

    /**
     * Suggests documents in the index that match the given partial query text.
     *
     * @param suggestRequest The Suggest request.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing suggestion query results from an index.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SuggestDocumentsResult suggestPost(SuggestRequest suggestRequest, RequestOptions requestOptions) {
        return suggestPostWithResponse(suggestRequest, requestOptions, Context.NONE).getValue();
    }

    /**
     * Sends a batch of document write actions to the index.
     *
     * @param batch The batch of index actions.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing the status of operations for all documents in the indexing request along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IndexDocumentsResult>> indexWithResponseAsync(
            IndexBatch batch, RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(
                context ->
                        service.index(
                                this.client.getEndpoint(),
                                this.client.getIndexName(),
                                this.client.getApiVersion(),
                                xMsClientRequestId,
                                accept,
                                batch,
                                context));
    }

    /**
     * Sends a batch of document write actions to the index.
     *
     * @param batch The batch of index actions.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing the status of operations for all documents in the indexing request along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<IndexDocumentsResult>> indexWithResponseAsync(
            IndexBatch batch, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.index(
                this.client.getEndpoint(),
                this.client.getIndexName(),
                this.client.getApiVersion(),
                xMsClientRequestId,
                accept,
                batch,
                context);
    }

    /**
     * Sends a batch of document write actions to the index.
     *
     * @param batch The batch of index actions.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing the status of operations for all documents in the indexing request on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IndexDocumentsResult> indexAsync(IndexBatch batch, RequestOptions requestOptions) {
        return indexWithResponseAsync(batch, requestOptions).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Sends a batch of document write actions to the index.
     *
     * @param batch The batch of index actions.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing the status of operations for all documents in the indexing request on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<IndexDocumentsResult> indexAsync(IndexBatch batch, RequestOptions requestOptions, Context context) {
        return indexWithResponseAsync(batch, requestOptions, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Sends a batch of document write actions to the index.
     *
     * @param batch The batch of index actions.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing the status of operations for all documents in the indexing request along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<IndexDocumentsResult> indexWithResponse(
            IndexBatch batch, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.indexSync(
                this.client.getEndpoint(),
                this.client.getIndexName(),
                this.client.getApiVersion(),
                xMsClientRequestId,
                accept,
                batch,
                context);
    }

    /**
     * Sends a batch of document write actions to the index.
     *
     * @param batch The batch of index actions.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing the status of operations for all documents in the indexing request.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public IndexDocumentsResult index(IndexBatch batch, RequestOptions requestOptions) {
        return indexWithResponse(batch, requestOptions, Context.NONE).getValue();
    }

    /**
     * Autocompletes incomplete query terms based on input text and matching terms in the index.
     *
     * @param autocompleteRequest The definition of the Autocomplete request.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of Autocomplete query along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AutocompleteResult>> autocompletePostWithResponseAsync(
            AutocompleteRequest autocompleteRequest, RequestOptions requestOptions) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(
                context ->
                        service.autocompletePost(
                                this.client.getEndpoint(),
                                this.client.getIndexName(),
                                xMsClientRequestId,
                                this.client.getApiVersion(),
                                accept,
                                autocompleteRequest,
                                context));
    }

    /**
     * Autocompletes incomplete query terms based on input text and matching terms in the index.
     *
     * @param autocompleteRequest The definition of the Autocomplete request.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of Autocomplete query along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AutocompleteResult>> autocompletePostWithResponseAsync(
            AutocompleteRequest autocompleteRequest, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.autocompletePost(
                this.client.getEndpoint(),
                this.client.getIndexName(),
                xMsClientRequestId,
                this.client.getApiVersion(),
                accept,
                autocompleteRequest,
                context);
    }

    /**
     * Autocompletes incomplete query terms based on input text and matching terms in the index.
     *
     * @param autocompleteRequest The definition of the Autocomplete request.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of Autocomplete query on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AutocompleteResult> autocompletePostAsync(
            AutocompleteRequest autocompleteRequest, RequestOptions requestOptions) {
        return autocompletePostWithResponseAsync(autocompleteRequest, requestOptions)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Autocompletes incomplete query terms based on input text and matching terms in the index.
     *
     * @param autocompleteRequest The definition of the Autocomplete request.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of Autocomplete query on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AutocompleteResult> autocompletePostAsync(
            AutocompleteRequest autocompleteRequest, RequestOptions requestOptions, Context context) {
        return autocompletePostWithResponseAsync(autocompleteRequest, requestOptions, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Autocompletes incomplete query terms based on input text and matching terms in the index.
     *
     * @param autocompleteRequest The definition of the Autocomplete request.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of Autocomplete query along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AutocompleteResult> autocompletePostWithResponse(
            AutocompleteRequest autocompleteRequest, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=none";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.autocompletePostSync(
                this.client.getEndpoint(),
                this.client.getIndexName(),
                xMsClientRequestId,
                this.client.getApiVersion(),
                accept,
                autocompleteRequest,
                context);
    }

    /**
     * Autocompletes incomplete query terms based on input text and matching terms in the index.
     *
     * @param autocompleteRequest The definition of the Autocomplete request.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws SearchErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of Autocomplete query.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AutocompleteResult autocompletePost(AutocompleteRequest autocompleteRequest, RequestOptions requestOptions) {
        return autocompletePostWithResponse(autocompleteRequest, requestOptions, Context.NONE).getValue();
    }
}
