// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Credentials of a registered application created for your search service, used for authenticated access to the
 * encryption keys stored in Azure Key Vault.
 */
@Fluent
public final class AzureActiveDirectoryApplicationCredentials
        implements JsonSerializable<AzureActiveDirectoryApplicationCredentials> {
    /*
     * An AAD Application ID that was granted the required access permissions to the Azure Key Vault that is to be used
     * when encrypting your data at rest. The Application ID should not be confused with the Object ID for your AAD
     * Application.
     */
    private String applicationId;

    /*
     * The authentication key of the specified AAD application.
     */
    private String applicationSecret;

    /** Creates an instance of AzureActiveDirectoryApplicationCredentials class. */
    public AzureActiveDirectoryApplicationCredentials() {}

    /**
     * Get the applicationId property: An AAD Application ID that was granted the required access permissions to the
     * Azure Key Vault that is to be used when encrypting your data at rest. The Application ID should not be confused
     * with the Object ID for your AAD Application.
     *
     * @return the applicationId value.
     */
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * Set the applicationId property: An AAD Application ID that was granted the required access permissions to the
     * Azure Key Vault that is to be used when encrypting your data at rest. The Application ID should not be confused
     * with the Object ID for your AAD Application.
     *
     * @param applicationId the applicationId value to set.
     * @return the AzureActiveDirectoryApplicationCredentials object itself.
     */
    public AzureActiveDirectoryApplicationCredentials setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    /**
     * Get the applicationSecret property: The authentication key of the specified AAD application.
     *
     * @return the applicationSecret value.
     */
    public String getApplicationSecret() {
        return this.applicationSecret;
    }

    /**
     * Set the applicationSecret property: The authentication key of the specified AAD application.
     *
     * @param applicationSecret the applicationSecret value to set.
     * @return the AzureActiveDirectoryApplicationCredentials object itself.
     */
    public AzureActiveDirectoryApplicationCredentials setApplicationSecret(String applicationSecret) {
        this.applicationSecret = applicationSecret;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("applicationId", this.applicationId);
        jsonWriter.writeStringField("applicationSecret", this.applicationSecret);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureActiveDirectoryApplicationCredentials from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureActiveDirectoryApplicationCredentials if the JsonReader was pointing to an instance
     *     of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureActiveDirectoryApplicationCredentials.
     */
    public static AzureActiveDirectoryApplicationCredentials fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    AzureActiveDirectoryApplicationCredentials deserializedAzureActiveDirectoryApplicationCredentials =
                            new AzureActiveDirectoryApplicationCredentials();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("applicationId".equals(fieldName)) {
                            deserializedAzureActiveDirectoryApplicationCredentials.applicationId = reader.getString();
                        } else if ("applicationSecret".equals(fieldName)) {
                            deserializedAzureActiveDirectoryApplicationCredentials.applicationSecret =
                                    reader.getString();
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedAzureActiveDirectoryApplicationCredentials;
                });
    }
}
