// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/** The DocumentKeysOrIds model. */
@Fluent
public final class DocumentKeysOrIds implements JsonSerializable<DocumentKeysOrIds> {
    /*
     * document keys to be reset
     */
    private List<String> documentKeys;

    /*
     * datasource document identifiers to be reset
     */
    private List<String> datasourceDocumentIds;

    /** Creates an instance of DocumentKeysOrIds class. */
    public DocumentKeysOrIds() {}

    /**
     * Get the documentKeys property: document keys to be reset.
     *
     * @return the documentKeys value.
     */
    public List<String> getDocumentKeys() {
        return this.documentKeys;
    }

    /**
     * Set the documentKeys property: document keys to be reset.
     *
     * @param documentKeys the documentKeys value to set.
     * @return the DocumentKeysOrIds object itself.
     */
    public DocumentKeysOrIds setDocumentKeys(List<String> documentKeys) {
        this.documentKeys = documentKeys;
        return this;
    }

    /**
     * Get the datasourceDocumentIds property: datasource document identifiers to be reset.
     *
     * @return the datasourceDocumentIds value.
     */
    public List<String> getDatasourceDocumentIds() {
        return this.datasourceDocumentIds;
    }

    /**
     * Set the datasourceDocumentIds property: datasource document identifiers to be reset.
     *
     * @param datasourceDocumentIds the datasourceDocumentIds value to set.
     * @return the DocumentKeysOrIds object itself.
     */
    public DocumentKeysOrIds setDatasourceDocumentIds(List<String> datasourceDocumentIds) {
        this.datasourceDocumentIds = datasourceDocumentIds;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("documentKeys", this.documentKeys, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField(
                "datasourceDocumentIds", this.datasourceDocumentIds, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentKeysOrIds from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentKeysOrIds if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the DocumentKeysOrIds.
     */
    public static DocumentKeysOrIds fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    DocumentKeysOrIds deserializedDocumentKeysOrIds = new DocumentKeysOrIds();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("documentKeys".equals(fieldName)) {
                            List<String> documentKeys = reader.readArray(reader1 -> reader1.getString());
                            deserializedDocumentKeysOrIds.documentKeys = documentKeys;
                        } else if ("datasourceDocumentIds".equals(fieldName)) {
                            List<String> datasourceDocumentIds = reader.readArray(reader1 -> reader1.getString());
                            deserializedDocumentKeysOrIds.datasourceDocumentIds = datasourceDocumentIds;
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedDocumentKeysOrIds;
                });
    }
}
