// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.EdgeNGramTokenFilterSide;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Generates n-grams of the given size(s) starting from the front or the back of an input token. This token filter is
 * implemented using Apache Lucene.
 */
@Fluent
public final class EdgeNGramTokenFilterV1 extends TokenFilter {
    /*
     * The minimum n-gram length. Default is 1. Must be less than the value of maxGram.
     */
    private Integer minGram;

    /*
     * The maximum n-gram length. Default is 2.
     */
    private Integer maxGram;

    /*
     * Specifies which side of the input the n-gram should be generated from. Default is "front".
     */
    private EdgeNGramTokenFilterSide side;

    /**
     * Creates an instance of EdgeNGramTokenFilterV1 class.
     *
     * @param name the name value to set.
     */
    public EdgeNGramTokenFilterV1(String name) {
        super(name);
    }

    /**
     * Get the minGram property: The minimum n-gram length. Default is 1. Must be less than the value of maxGram.
     *
     * @return the minGram value.
     */
    public Integer getMinGram() {
        return this.minGram;
    }

    /**
     * Set the minGram property: The minimum n-gram length. Default is 1. Must be less than the value of maxGram.
     *
     * @param minGram the minGram value to set.
     * @return the EdgeNGramTokenFilterV1 object itself.
     */
    public EdgeNGramTokenFilterV1 setMinGram(Integer minGram) {
        this.minGram = minGram;
        return this;
    }

    /**
     * Get the maxGram property: The maximum n-gram length. Default is 2.
     *
     * @return the maxGram value.
     */
    public Integer getMaxGram() {
        return this.maxGram;
    }

    /**
     * Set the maxGram property: The maximum n-gram length. Default is 2.
     *
     * @param maxGram the maxGram value to set.
     * @return the EdgeNGramTokenFilterV1 object itself.
     */
    public EdgeNGramTokenFilterV1 setMaxGram(Integer maxGram) {
        this.maxGram = maxGram;
        return this;
    }

    /**
     * Get the side property: Specifies which side of the input the n-gram should be generated from. Default is "front".
     *
     * @return the side value.
     */
    public EdgeNGramTokenFilterSide getSide() {
        return this.side;
    }

    /**
     * Set the side property: Specifies which side of the input the n-gram should be generated from. Default is "front".
     *
     * @param side the side value to set.
     * @return the EdgeNGramTokenFilterV1 object itself.
     */
    public EdgeNGramTokenFilterV1 setSide(EdgeNGramTokenFilterSide side) {
        this.side = side;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.EdgeNGramTokenFilter");
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeNumberField("minGram", this.minGram);
        jsonWriter.writeNumberField("maxGram", this.maxGram);
        jsonWriter.writeStringField("side", Objects.toString(this.side, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EdgeNGramTokenFilterV1 from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of EdgeNGramTokenFilterV1 if the JsonReader was pointing to an instance of it, or null if it
     *     was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties or the
     *     polymorphic discriminator.
     * @throws IOException If an error occurs while reading the EdgeNGramTokenFilterV1.
     */
    public static EdgeNGramTokenFilterV1 fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    boolean nameFound = false;
                    String name = null;
                    Integer minGram = null;
                    Integer maxGram = null;
                    EdgeNGramTokenFilterSide side = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("@odata.type".equals(fieldName)) {
                            String odataType = reader.getString();
                            if (!"#Microsoft.Azure.Search.EdgeNGramTokenFilter".equals(odataType)) {
                                throw new IllegalStateException(
                                        "'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.EdgeNGramTokenFilter'. The found '@odata.type' was '"
                                                + odataType
                                                + "'.");
                            }
                        } else if ("name".equals(fieldName)) {
                            name = reader.getString();
                            nameFound = true;
                        } else if ("minGram".equals(fieldName)) {
                            minGram = reader.getNullable(JsonReader::getInt);
                        } else if ("maxGram".equals(fieldName)) {
                            maxGram = reader.getNullable(JsonReader::getInt);
                        } else if ("side".equals(fieldName)) {
                            side = EdgeNGramTokenFilterSide.fromString(reader.getString());
                        } else {
                            reader.skipChildren();
                        }
                    }
                    if (nameFound) {
                        EdgeNGramTokenFilterV1 deserializedEdgeNGramTokenFilterV1 = new EdgeNGramTokenFilterV1(name);
                        deserializedEdgeNGramTokenFilterV1.minGram = minGram;
                        deserializedEdgeNGramTokenFilterV1.maxGram = maxGram;
                        deserializedEdgeNGramTokenFilterV1.side = side;

                        return deserializedEdgeNGramTokenFilterV1;
                    }
                    List<String> missingProperties = new ArrayList<>();
                    if (!nameFound) {
                        missingProperties.add("name");
                    }

                    throw new IllegalStateException(
                            "Missing required property/properties: " + String.join(", ", missingProperties));
                });
    }
}
