// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/** Response from a List Datasources request. If successful, it includes the full definitions of all datasources. */
@Immutable
public final class ListDataSourcesResult implements JsonSerializable<ListDataSourcesResult> {
    /*
     * The datasources in the Search service.
     */
    private final List<SearchIndexerDataSourceConnection> dataSources;

    /**
     * Creates an instance of ListDataSourcesResult class.
     *
     * @param dataSources the dataSources value to set.
     */
    public ListDataSourcesResult(List<SearchIndexerDataSourceConnection> dataSources) {
        this.dataSources = dataSources;
    }

    /**
     * Get the dataSources property: The datasources in the Search service.
     *
     * @return the dataSources value.
     */
    public List<SearchIndexerDataSourceConnection> getDataSources() {
        return this.dataSources;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListDataSourcesResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListDataSourcesResult if the JsonReader was pointing to an instance of it, or null if it
     *     was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ListDataSourcesResult.
     */
    public static ListDataSourcesResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    boolean dataSourcesFound = false;
                    List<SearchIndexerDataSourceConnection> dataSources = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("value".equals(fieldName)) {
                            dataSources =
                                    reader.readArray(reader1 -> SearchIndexerDataSourceConnection.fromJson(reader1));
                            dataSourcesFound = true;
                        } else {
                            reader.skipChildren();
                        }
                    }
                    if (dataSourcesFound) {
                        ListDataSourcesResult deserializedListDataSourcesResult =
                                new ListDataSourcesResult(dataSources);

                        return deserializedListDataSourcesResult;
                    }
                    List<String> missingProperties = new ArrayList<>();
                    if (!dataSourcesFound) {
                        missingProperties.add("value");
                    }

                    throw new IllegalStateException(
                            "Missing required property/properties: " + String.join(", ", missingProperties));
                });
    }
}
