// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** Base type for describing any Azure AI service resource attached to a skillset. */
@Fluent
public abstract class CognitiveServicesAccount implements JsonSerializable<CognitiveServicesAccount> {
    /*
     * Description of the Azure AI service resource attached to a skillset.
     */
    private String description;

    /** Creates an instance of CognitiveServicesAccount class. */
    public CognitiveServicesAccount() {}

    /**
     * Get the description property: Description of the Azure AI service resource attached to a skillset.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Description of the Azure AI service resource attached to a skillset.
     *
     * @param description the description value to set.
     * @return the CognitiveServicesAccount object itself.
     */
    public CognitiveServicesAccount setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CognitiveServicesAccount from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CognitiveServicesAccount if the JsonReader was pointing to an instance of it, or null if
     *     it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing the polymorphic discriminator.
     * @throws IOException If an error occurs while reading the CognitiveServicesAccount.
     */
    public static CognitiveServicesAccount fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    String discriminatorValue = null;
                    JsonReader readerToUse = reader.bufferObject();

                    readerToUse.nextToken(); // Prepare for reading
                    while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = readerToUse.getFieldName();
                        readerToUse.nextToken();
                        if ("@odata.type".equals(fieldName)) {
                            discriminatorValue = readerToUse.getString();
                            break;
                        } else {
                            readerToUse.skipChildren();
                        }
                    }

                    if (discriminatorValue != null) {
                        readerToUse = readerToUse.reset();
                    }
                    // Use the discriminator value to determine which subtype should be deserialized.
                    if ("#Microsoft.Azure.Search.DefaultCognitiveServices".equals(discriminatorValue)) {
                        return DefaultCognitiveServicesAccount.fromJson(readerToUse);
                    } else if ("#Microsoft.Azure.Search.CognitiveServicesByKey".equals(discriminatorValue)) {
                        return CognitiveServicesAccountKey.fromJson(readerToUse);
                    } else {
                        throw new IllegalStateException(
                                "Discriminator field '@odata.type' didn't match one of the expected values '#Microsoft.Azure.Search.DefaultCognitiveServices', or '#Microsoft.Azure.Search.CognitiveServicesByKey'. It was: '"
                                        + discriminatorValue
                                        + "'.");
                    }
                });
    }
}
